/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.spring;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.io.IOUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;

public class StreamingMultipartFile
implements MultipartFile {
    private final FileItemStream item;
    private final long size = -1L;
    private final byte[] bytes;

    public StreamingMultipartFile(FileItemStream item) throws IOException {
        this.item = item;
        this.bytes = IOUtils.toByteArray((InputStream)item.openStream());
    }

    public String getName() {
        return this.item.getName();
    }

    public String getOriginalFilename() {
        return this.item.getFieldName();
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public boolean isEmpty() {
        return false;
    }

    public long getSize() {
        try {
            return this.getBytes().length;
        }
        catch (IOException e) {
            throw new MultipartException("Something went wrong here", (Throwable)e);
        }
    }

    public byte[] getBytes() throws IOException {
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return this.item.openStream();
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("transfer to file not implemented");
    }
}

