/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.spring;

import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.tangram.monitor.Statistics;

public class MeasureTimeInterceptor
extends HandlerInterceptorAdapter {
    @Resource(name="freeUrls")
    private Set<String> freeUrls;
    @Inject
    private Statistics statistics;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("start.time", (Object)System.currentTimeMillis());
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String thisURL = request.getRequestURI();
        if (!this.freeUrls.contains(thisURL)) {
            Long startTime = (Long)request.getAttribute("start.time");
            this.statistics.avg("page render time", System.currentTimeMillis() - startTime);
        }
        super.afterCompletion(request, response, handler, ex);
    }
}

