/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components.spring;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;

@Named
@Singleton
public final class TangramSpringServices
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(TangramSpringServices.class);
    private static ApplicationContext applicationContext;

    private TangramSpringServices() {
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Inject
    public void setApplicationContext(ApplicationContext applicationContext) {
        TangramSpringServices.applicationContext = applicationContext;
    }

    public static <T> T getBeanFromContext(Class<? extends T> cls) {
        Object result;
        ApplicationContext appContext = TangramSpringServices.getApplicationContext();
        Object object = result = appContext != null ? appContext.getBean(cls) : null;
        if (result == null) {
            throw new RuntimeException("getBeanFromContext() no item of type " + cls.getName() + " available.");
        }
        return (T)result;
    }

    public static <T> T getBeanFromContext(Class<? extends T> cls, String name) {
        Object result;
        ApplicationContext appContext = TangramSpringServices.getApplicationContext();
        Object object = result = appContext != null ? appContext.getBean(name, cls) : null;
        if (result == null) {
            throw new RuntimeException("getBeanFromContext() no item of type " + cls.getName() + " and Name " + name + " available.");
        }
        return (T)result;
    }

    public static ConversionService getConversionService() {
        return ConversionServiceHolder.INSTANCE;
    }

    public static BeanWrapper createWrapper(Object bean) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        try {
            ConversionService converter = TangramSpringServices.getConversionService();
            if (converter != null) {
                wrapper.setConversionService(converter);
            }
            LOG.info("createWrapper() conversion service {}", (Object)wrapper.getConversionService());
        }
        catch (Exception e) {
            LOG.warn("createWrapper()", (Throwable)e);
        }
        return wrapper;
    }

    private static class ConversionServiceHolder {
        public static final ConversionService INSTANCE = TangramSpringServices.getBeanFromContext(ConversionService.class);

        private ConversionServiceHolder() {
        }
    }
}

