/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.spring.view;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.tangram.util.SystemUtils;
import org.tangram.view.AbstractRequestParameterAccess;

public class SpringRequestParameterAccess
extends AbstractRequestParameterAccess {
    private static final Logger LOG = LoggerFactory.getLogger(SpringRequestParameterAccess.class);

    SpringRequestParameterAccess(HttpServletRequest request) throws Exception {
        if (request instanceof DefaultMultipartHttpServletRequest) {
            DefaultMultipartHttpServletRequest r = (DefaultMultipartHttpServletRequest)request;
            Map fileMap = r.getFileMap();
            for (Map.Entry entry : fileMap.entrySet()) {
                if (((MultipartFile)entry.getValue()).getContentType().equals("errorcode")) {
                    throw new Exception(((MultipartFile)entry.getValue()).getOriginalFilename());
                }
                String key = (String)entry.getKey();
                String filename = ((MultipartFile)entry.getValue()).getName();
                LOG.info("() name {}", (Object)filename);
                LOG.info("() size {}", (Object)((MultipartFile)entry.getValue()).getSize());
                String originalFilename = ((MultipartFile)entry.getValue()).getOriginalFilename();
                LOG.debug("() key {} original filename {}", (Object)key, (Object)originalFilename);
                if (filename.length() <= 0) continue;
                LOG.info("multipart file {}", (Object)key);
                try {
                    this.originalNames.put(key, originalFilename);
                    this.blobs.put(key, ((MultipartFile)entry.getValue()).getBytes());
                }
                catch (IOException ex) {
                    LOG.error("()", (Throwable)ex);
                }
            }
        }
        this.parameterMap = (Map)SystemUtils.convert((Object)request.getParameterMap());
    }
}

