/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.spring.view;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.tangram.components.spring.SpringViewUtilities;
import org.tangram.spring.view.ModelAwareViewResolver;
import org.tangram.view.AbstractInternalResourceTemplateResolver;

public class ModelAwareInternalResourceViewResolver
extends AbstractInternalResourceTemplateResolver<View>
implements ServletContextAware,
ModelAwareViewResolver {
    private int order = Integer.MAX_VALUE;
    private UrlBasedViewResolver delegate;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public UrlBasedViewResolver getDelegate() {
        return this.delegate;
    }

    public void setDelegate(UrlBasedViewResolver delegate) {
        this.delegate = delegate;
    }

    protected View getNotFoundDummy() {
        return SpringViewUtilities.NOT_FOUND_DUMMY;
    }

    protected View checkResourceExists(View result) {
        String url = ((AbstractUrlBasedView)result).getUrl();
        return this.checkJspExists(url) != null ? result : null;
    }

    protected View resolveView(String path, Locale locale) throws Exception {
        return this.delegate.resolveViewName(path, locale);
    }

    @Override
    public View resolveView(String viewName, Map<String, Object> model, Locale locale) throws IOException {
        return (View)this.resolveTemplate(viewName, model, locale);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.delegate, (String)"delegate is null");
        this.delegate.setPrefix(this.getPrefix());
        this.delegate.setSuffix(this.getSuffix());
    }
}

