/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.web.servlet.View;
import org.tangram.spring.view.ModelAwareViewResolver;
import org.tangram.spring.view.ViewHandler;

@Named(value="viewHandler")
public class TangramViewHandler
implements ViewHandler,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(TangramViewHandler.class);
    private ApplicationContext applicationContext;
    private List<ModelAwareViewResolver> modelAwareViewResolvers;
    private boolean detectAllModelAwareViewResolvers = true;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean isDetectAllModelAwareViewResolvers() {
        return this.detectAllModelAwareViewResolvers;
    }

    public void setDetectAllModelAwareViewResolvers(boolean detectAllModelAwareViewResolvers) {
        this.detectAllModelAwareViewResolvers = detectAllModelAwareViewResolvers;
    }

    private void initViewResolvers(ApplicationContext context) {
        this.modelAwareViewResolvers = null;
        if (this.detectAllModelAwareViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, ModelAwareViewResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.modelAwareViewResolvers = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.modelAwareViewResolvers);
            }
        } else {
            try {
                ModelAwareViewResolver vr = (ModelAwareViewResolver)context.getBean("viewResolver", ModelAwareViewResolver.class);
                this.modelAwareViewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException e) {
                LOG.warn("initViewResolvers()", (Throwable)e);
            }
        }
    }

    @Override
    public View resolveView(String viewName, Map<String, Object> model, Locale locale, ServletRequest request) throws IOException {
        View result = null;
        for (ModelAwareViewResolver viewResolver : this.modelAwareViewResolvers) {
            View view = viewResolver.resolveView(viewName, model, locale);
            if (view == null) continue;
            result = view;
            break;
        }
        return result;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.initViewResolvers(this.applicationContext);
    }
}

