/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components.spring;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.tangram.components.spring.SpringViewUtilities;
import org.tangram.content.Content;
import org.tangram.controller.AbstractRenderingBase;
import org.tangram.link.InternalLinkFactory;
import org.tangram.link.Link;
import org.tangram.view.TargetDescriptor;
import org.tangram.view.Utils;
import org.tangram.view.ViewContext;

@Controller
public class DefaultController
extends AbstractRenderingBase
implements InternalLinkFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultController.class);

    @RequestMapping(value={"/id_{id}/view_{view}"})
    public ModelAndView render(@PathVariable(value="id") String id, @PathVariable(value="view") String view, HttpServletRequest request, HttpServletResponse response) {
        try {
            Utils.setPrimaryBrowserLanguageForJstl((HttpServletRequest)request);
            LOG.debug("render() id={} view={}", (Object)id, (Object)view);
            Content content = this.beanFactory.getBean(id);
            LOG.debug("render() content={}", (Object)content);
            if (content == null) {
                response.sendError(404, "no content with id " + id + " in repository.");
                return null;
            }
            Map model = this.createModel(new TargetDescriptor((Object)content, view, null), request, response);
            ViewContext viewContext = this.viewContextFactory.createViewContext(model, view);
            return SpringViewUtilities.createModelAndView(viewContext);
        }
        catch (Exception e) {
            ViewContext viewContext = this.viewContextFactory.createViewContext((Object)e, (ServletRequest)request, (ServletResponse)response);
            return SpringViewUtilities.createModelAndView(viewContext);
        }
    }

    @RequestMapping(value={"/id_{id}"})
    public ModelAndView render(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) {
        return this.render(id, null, request, response);
    }

    public Link createLink(HttpServletRequest request, HttpServletResponse r, Object bean, String action, String view) {
        if (bean instanceof Content) {
            return AbstractRenderingBase.createDefaultLink((Object)bean, (String)action, (String)view);
        }
        return null;
    }
}

