/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components.nucleus;

import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.jdo.annotations.PersistenceCapable;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.BeanListener;
import org.tangram.content.Content;
import org.tangram.jdo.JdoBeanFactory;
import org.tangram.logic.ClassRepository;

@Named
@Singleton
public class ClassRepositoryEnhancer
implements BeanListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClassRepositoryEnhancer.class);
    @Inject
    private ClassRepository classRepository;
    @Inject
    private JdoBeanFactory beanFactory;

    public void reset() {
        Map classes = this.classRepository.get(Content.class);
        LOG.info("reset() number of classes {}", (Object)classes.size());
        HashSet<Class> modelClasses = new HashSet<Class>();
        for (Class c : classes.values()) {
            if (c.getAnnotation(PersistenceCapable.class) == null) continue;
            LOG.info("reset() defining {}", (Object)c.getName());
            try {
                DataNucleusEnhancer enhancer = new DataNucleusEnhancer();
                enhancer.setVerbose(true);
                enhancer.setSystemOut(true);
                String classname = c.getName();
                enhancer.setClassLoader(this.classRepository.getClassLoader());
                enhancer.addClass(classname, this.classRepository.getBytes(classname));
                int numClasses = enhancer.enhance();
                if (numClasses > 0) {
                    byte[] enhancedBytes = enhancer.getEnhancedBytes(classname);
                    this.classRepository.overrideClass(classname, enhancedBytes);
                    Class enhancedClass = this.classRepository.get(classname);
                    modelClasses.add(enhancedClass);
                    continue;
                }
                LOG.error("reset() cannot integrate model class " + classname);
            }
            catch (Throwable e) {
                LOG.error("reset()", e);
            }
        }
        this.beanFactory.setAdditionalClasses(modelClasses);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.classRepository.addListener((BeanListener)this);
        this.reset();
    }
}

