/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components.mutable;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.annotate.ActionParameter;
import org.tangram.annotate.LinkAction;
import org.tangram.annotate.LinkHandler;
import org.tangram.content.CodeResource;
import org.tangram.content.CodeResourceCache;
import org.tangram.content.Content;
import org.tangram.link.LinkHandlerRegistry;
import org.tangram.link.TargetDescriptor;
import org.tangram.monitor.Statistics;
import org.tangram.mutable.CodeHelper;
import org.tangram.mutable.MutableBeanFactory;
import org.tangram.protection.AuthorizationService;
import org.tangram.util.SystemUtils;
import org.tangram.view.Utils;

@Named
@Singleton
@LinkHandler
public class ToolHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ToolHandler.class);
    @Inject
    private LinkHandlerRegistry registry;
    @Inject
    private Statistics statistics;
    @Inject
    private MutableBeanFactory<?, ?> beanFactory;
    @Inject
    private CodeResourceCache codeResourceCache;
    @Inject
    private AuthorizationService authorizationService;

    private void prepareView(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("handler", (Object)this);
        request.setAttribute("prefix", (Object)Utils.getUriPrefix((HttpServletRequest)request));
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
    }

    @LinkAction(value="/clear/caches")
    public TargetDescriptor clearCaches(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.authorizationService.isAdminUser(request, response)) {
            return this.authorizationService.getLoginTarget(request);
        }
        LOG.info("clearCaches() clearing class specific caches");
        for (Class<Content> c : this.beanFactory.getClasses()) {
            if (c.isInterface() || (c.getModifiers() & 0x400) > 0) {
                LOG.info("clearCaches() {} may not have instances", (Object)c.getSimpleName());
                continue;
            }
            this.beanFactory.clearCacheFor(c);
        }
        return new TargetDescriptor((Object)this.statistics, null, null);
    }

    private String getFilename(CodeResource code) {
        return code.getAnnotation().replace(';', '_');
    }

    @LinkAction(value="/codes.zip")
    public TargetDescriptor codeExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.getRequestURI().endsWith(".zip")) {
            response.sendError(404);
            return null;
        }
        if (!this.authorizationService.isAdminUser(request, response)) {
            return this.authorizationService.getLoginTarget(request);
        }
        long now = System.currentTimeMillis();
        response.setContentType("application/x-zip-compressed");
        CRC32 crc = new CRC32();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
        zos.setComment("Tangram Repository Codes");
        zos.setLevel(9);
        Collection codes = this.codeResourceCache.getCodes();
        for (CodeResource code : codes) {
            if (!StringUtils.isNotBlank((String)code.getAnnotation())) continue;
            String mimeType = code.getMimeType();
            String folder = CodeHelper.getFolder(mimeType);
            String extension = CodeHelper.getExtension(mimeType);
            if (!CodeHelper.getCodeMimeTypes().contains(mimeType)) continue;
            try {
                byte[] bytes = code.getCodeText().getBytes("UTF-8");
                ZipEntry ze = new ZipEntry(folder + "/" + this.getFilename(code) + extension);
                ze.setComment(mimeType);
                ze.setSize(bytes.length);
                ze.setTime(now);
                crc.reset();
                crc.update(bytes);
                ze.setCrc(crc.getValue());
                zos.putNextEntry(ze);
                zos.write(bytes);
                zos.closeEntry();
            }
            catch (IOException ioe) {
                LOG.error("codeExport()", (Throwable)ioe);
            }
        }
        zos.finish();
        zos.close();
        return TargetDescriptor.DONE;
    }

    @LinkAction(value="/codes")
    public TargetDescriptor codeImport(@ActionParameter(value="zipfile") byte[] zipfile, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.authorizationService.throwIfNotAdmin(request, response, "Import should not be called directly");
        if (zipfile == null) {
            throw new Exception("You missed to select an input file.");
        }
        ZipInputStream zip = new ZipInputStream((InputStream)new ByteArrayInputStream(zipfile), Charset.forName("UTF-8"));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (!name.endsWith("/")) {
                String[] pathAndName = name.split("/");
                String mimetype = entry.getComment();
                if (StringUtils.isEmpty((String)mimetype)) {
                    mimetype = CodeHelper.getMimetype(pathAndName[0]);
                }
                if (CodeHelper.getCodeMimeTypes().contains(mimetype)) {
                    LOG.info("codeImport() {}: {} / {} ({}) ({}/{})", new Object[]{pathAndName[0], pathAndName.length > 1 ? pathAndName[1] : "*", mimetype, entry.getComment(), entry.getCompressedSize(), entry.getSize()});
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int len = zip.read(buffer);
                    while (len >= 0) {
                        baos.write(buffer, 0, len);
                        len = zip.read(buffer);
                    }
                    byte[] data = baos.toByteArray();
                    LOG.debug("codeImport() code {}", (Object)new String(data, "UTF-8"));
                    CodeHelper.updateCode(this.beanFactory, this.codeResourceCache, mimetype, pathAndName[1], data, entry.getTime());
                } else {
                    LOG.info("codeImport() ignoring {} for its mime type {}.", (Object)name, (Object)mimetype);
                }
            } else {
                LOG.info("codeImport() {} is a folder.", (Object)name);
            }
            entry = zip.getNextEntry();
        }
        this.prepareView(request, response);
        return new TargetDescriptor((Object)this, null, null);
    }

    @LinkAction(value="/export")
    public TargetDescriptor contentExport(@ActionParameter(value="classes") String classList, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.authorizationService.isAdminUser(request, response)) {
            return this.authorizationService.getLoginTarget(request);
        }
        response.setContentType("application/xml");
        response.setCharacterEncoding("UTF-8");
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        Collection<Class<Content>> classes = this.beanFactory.getClasses();
        Class<Content> oneClass = classes.iterator().next();
        while (oneClass.getSuperclass() != Object.class) {
            oneClass = oneClass.getSuperclass();
        }
        LOG.info("contentExport() root class to ignore fields in: {}", (Object)oneClass.getName());
        xstream.omitField(oneClass, "id");
        xstream.omitField(oneClass, "ebeanInternalId");
        xstream.omitField(oneClass, "__ebean__intercept");
        Class<Content> baseClass = this.beanFactory.getBaseClass();
        if (baseClass != oneClass) {
            LOG.info("contentExport() additional base class to ignore fields in: {}", (Object)oneClass.getName());
            xstream.omitField(baseClass, "id");
            xstream.omitField(baseClass, "ebeanInternalId");
            xstream.omitField(baseClass, "__ebean__intercept");
            xstream.omitField(baseClass, "beanFactory");
        }
        for (Class<Content> clazz : this.beanFactory.getAllClasses()) {
            LOG.info("contentExport() aliasing and ignoring fields for {}", (Object)clazz.getName());
            xstream.omitField(clazz, "beanFactory");
            xstream.omitField(clazz, "userServices");
            xstream.omitField(clazz, "__ebean__intercept");
            xstream.alias(clazz.getSimpleName(), clazz);
        }
        ArrayList<Class<Object>> sortedClasses = new ArrayList<Class<Object>>();
        sortedClasses.add(this.beanFactory.getImplementingClasses(CodeResource.class).get(0));
        for (String className : StringUtils.isNotEmpty((String)classList) ? classList.split(",") : new String[]{}) {
            for (Class<Content> c : classes) {
                if (!c.getSimpleName().equals(className.trim()) || sortedClasses.contains(c)) continue;
                sortedClasses.add(c);
            }
        }
        for (Class<Content> clazz : classes) {
            if (sortedClasses.contains(clazz)) continue;
            sortedClasses.add(clazz);
        }
        LOG.info("contentExport() sorted classes {}", sortedClasses);
        ArrayList arrayList = new ArrayList();
        for (Class c : sortedClasses) {
            try {
                arrayList.addAll(this.beanFactory.listBeansOfExactClass(c));
            }
            catch (Exception e) {
                LOG.error("contentExport()/list", (Throwable)e);
            }
        }
        try {
            xstream.toXML(arrayList, (Writer)response.getWriter());
            response.getWriter().flush();
        }
        catch (IOException iOException) {
            LOG.error("contentExport()/toxml", (Throwable)iOException);
        }
        return TargetDescriptor.DONE;
    }

    public void contentImport(Reader input) {
        this.beanFactory.beginTransaction();
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        Collection<Class<Content>> classes = this.beanFactory.getClasses();
        for (Class<Content> c : classes) {
            xstream.alias(c.getSimpleName(), c);
        }
        Object contents = xstream.fromXML(input);
        LOG.info("contentImport() implementation map {}", this.beanFactory.getImplementingClassesMap());
        if (contents instanceof List) {
            List list = SystemUtils.convertList((Object)contents);
            LOG.info("contentImport() {} objects in list", (Object)list.size());
            for (Content o : list) {
                if (!this.beanFactory.persistUncommitted(o)) continue;
                LOG.info("contentImport() {}", (Object)o);
            }
        } else {
            LOG.error("contentImport() Trying to import a non-list");
        }
        this.beanFactory.commitTransaction();
    }

    @LinkAction(value="/import")
    public TargetDescriptor contentImportLink(@ActionParameter(value="xmlfile") byte[] xmlfile, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.authorizationService.throwIfNotAdmin(request, response, "Import should not be called directly");
        if (xmlfile == null) {
            throw new Exception("You missed to select an input file.");
        }
        if (xmlfile.length < 5) {
            throw new Exception("Insufficient XML input.");
        }
        StringReader input = new StringReader(new String(xmlfile, "UTF-8"));
        this.contentImport(input);
        return TargetDescriptor.DONE;
    }

    @LinkAction(value="/tools")
    public TargetDescriptor importer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.authorizationService.isAdminUser(request, response)) {
            return this.authorizationService.getLoginTarget(request);
        }
        this.prepareView(request, response);
        return new TargetDescriptor((Object)this, null, null);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet()");
        this.registry.registerLinkHandler((Object)this);
    }
}

