/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.mutable;

import java.util.HashSet;
import java.util.Set;
import org.tangram.content.CodeResource;
import org.tangram.content.CodeResourceCache;
import org.tangram.mutable.MutableBeanFactory;
import org.tangram.mutable.MutableCode;

public final class CodeHelper {
    private static final Set<String> EXTENSION_TO_CUT = new HashSet<String>();
    private static final Set<String> MIME_TYPES = new HashSet<String>();

    private CodeHelper() {
    }

    public static Set<String> getCodeMimeTypes() {
        return MIME_TYPES;
    }

    public static String getExtension(String mimeType) {
        if ("application/x-groovy".equals(mimeType)) {
            mimeType = "text/groovy";
        }
        if ("text/html".equals(mimeType)) {
            mimeType = "text/vtl";
        }
        if ("application/xml".equals(mimeType)) {
            mimeType = "text/vtl";
        }
        if ("application/javascript".equals(mimeType)) {
            mimeType = "text/js";
        }
        if ("text/x-markdown".equals(mimeType)) {
            mimeType = "text/md";
        }
        if ("text/plain".equals(mimeType)) {
            mimeType = "";
        }
        if (mimeType.startsWith("text/")) {
            mimeType = "." + mimeType.substring(5);
        }
        return mimeType;
    }

    public static String getFolder(String mimeType) {
        if ("application/x-groovy".equals(mimeType)) {
            mimeType = "text/groovy";
        }
        if ("text/html".equals(mimeType)) {
            mimeType = "text/velocity";
        }
        if ("application/xml".equals(mimeType)) {
            mimeType = "text/velocity-xml";
        }
        if ("application/javascript".equals(mimeType)) {
            mimeType = "text/js";
        }
        if ("text/x-markdown".equals(mimeType)) {
            mimeType = "text/markdown";
        }
        if (mimeType.startsWith("text/")) {
            mimeType = mimeType.substring(5);
        }
        return mimeType;
    }

    public static String getMimetype(String directoryName) {
        String result = "text/plain";
        if ("velocity".equals(directoryName)) {
            result = "text/html";
        }
        if ("velocity-xml".equals(directoryName)) {
            result = "application/xml";
        }
        if ("css".equals(directoryName)) {
            result = "text/css";
        }
        if ("js".equals(directoryName)) {
            result = "application/javascript";
        }
        if ("groovy".equals(directoryName)) {
            result = "application/x-groovy";
        }
        if ("markdown".equals(directoryName)) {
            result = "text/x-markdown";
        }
        return result;
    }

    public static String getAnnotation(String filename) {
        int idx = filename.lastIndexOf(46);
        String extension = filename.substring(idx);
        if (EXTENSION_TO_CUT.contains(extension)) {
            filename = filename.substring(0, idx);
        }
        idx = filename.lastIndexOf(46);
        if (filename.endsWith(".vtl")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".css")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".js")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".groovy")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".md")) {
            filename = filename.substring(0, idx);
        }
        return filename;
    }

    public static void updateCode(MutableBeanFactory beanFactory, CodeResourceCache codeResourceCache, String mimetype, String filename, byte[] contents, long modificationTime) throws Exception {
        Class<MutableCode> codeClass = beanFactory.getImplementingClasses(MutableCode.class).get(0);
        String annotation = CodeHelper.getAnnotation(filename);
        CodeResource lookup = codeResourceCache.get(mimetype, annotation);
        MutableCode code = lookup == null ? beanFactory.createBean(codeClass) : (MutableCode)beanFactory.getBean(codeClass, lookup.getId());
        beanFactory.beginTransaction();
        code.setAnnotation(annotation);
        code.setCode(new String(contents, "UTF-8").toCharArray());
        code.setMimeType(mimetype);
        code.setModificationTime(modificationTime);
        beanFactory.persist(code);
    }

    static {
        EXTENSION_TO_CUT.add(".new");
        EXTENSION_TO_CUT.add(".old");
        MIME_TYPES.add("application/xml");
        MIME_TYPES.add("text/html");
        MIME_TYPES.add("text/css");
        MIME_TYPES.add("application/javascript");
        MIME_TYPES.add("application/x-groovy");
        MIME_TYPES.add("text/x-markdown");
    }
}

