/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.mutable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.PersistentRestartCache;
import org.tangram.annotate.Abstract;
import org.tangram.content.AbstractBeanFactory;
import org.tangram.content.BeanFactory;
import org.tangram.content.BeanFactoryAware;
import org.tangram.content.BeanListener;
import org.tangram.content.CodeResource;
import org.tangram.content.Content;
import org.tangram.content.TransientCode;
import org.tangram.monitor.Statistics;
import org.tangram.mutable.MutableBeanFactory;
import org.tangram.util.ClassResolver;
import org.tangram.util.SystemUtils;

public abstract class AbstractMutableBeanFactory
extends AbstractBeanFactory
implements MutableBeanFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMutableBeanFactory.class);
    protected static final String QUERY_CACHE_KEY = "tangram.query.cache";
    @Inject
    protected Statistics statistics;
    @Inject
    protected PersistentRestartCache startupCache;
    private final Map<Class<? extends Content>, List<BeanListener>> attachedListeners = new HashMap<Class<? extends Content>, List<BeanListener>>();
    private Set<String> basePackages;
    protected Map<Class<? extends Content>, List<Class<? extends Content>>> implementingClassesMap = null;
    protected List<Class<? extends Content>> modelClasses = null;
    protected Map<String, Class<? extends Content>> tableNameMapping = null;
    protected Map<String, Content> cache = new HashMap<String, Content>();
    private boolean activateCaching = false;
    protected Map<String, List<String>> queryCache = new HashMap<String, List<String>>();
    private boolean activateQueryCaching = false;

    public AbstractMutableBeanFactory() {
        this.basePackages = new HashSet<String>();
        this.basePackages.add(this.getBaseClass().getPackage().getName());
    }

    public Set<String> getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(Set<String> basePackages) {
        this.basePackages = basePackages;
    }

    public boolean isActivateCaching() {
        return this.activateCaching;
    }

    public void setActivateCaching(boolean activateCaching) {
        this.activateCaching = activateCaching;
    }

    public boolean isActivateQueryCaching() {
        return this.activateQueryCaching;
    }

    public void setActivateQueryCaching(boolean activateQueryCaching) {
        this.activateQueryCaching = activateQueryCaching;
    }

    protected Map<Class<? extends Content>, List<BeanListener>> getListeners() {
        return this.attachedListeners;
    }

    protected abstract boolean hasManager();

    protected abstract <T extends Content> void apiPersist(T var1);

    protected abstract <T extends Content> void apiDelete(T var1);

    @Override
    public <T extends Content> T createBean(Class<T> cls) throws InstantiationException, IllegalAccessException {
        LOG.debug("createBean() beginning transaction");
        this.beginTransaction();
        LOG.debug("createBean() creating new instance of {}", (Object)cls.getName());
        Content bean = (Content)cls.newInstance();
        this.statistics.increase("create bean");
        return (T)bean;
    }

    protected String getClassNamesCacheKey() {
        return "tangram-class-names";
    }

    @Override
    public <T extends Content> boolean persistUncommitted(T bean) {
        boolean result;
        block2: {
            result = false;
            boolean rollback = true;
            try {
                this.apiPersist(bean);
                rollback = false;
                this.clearCacheFor(bean.getClass());
                result = true;
            }
            catch (Exception e) {
                LOG.error("persistUncommitted()", (Throwable)e);
                if (!rollback || !this.hasManager()) break block2;
                this.rollbackTransaction();
            }
        }
        return result;
    }

    @Override
    public <T extends Content> boolean delete(T bean) {
        boolean result;
        block2: {
            result = false;
            boolean rollback = true;
            try {
                this.apiDelete(bean);
                this.commitTransaction();
                rollback = false;
                this.clearCacheFor(bean.getClass());
                result = true;
            }
            catch (Exception e) {
                LOG.error("delete()", (Throwable)e);
                if (!rollback || !this.hasManager()) break block2;
                this.rollbackTransaction();
            }
        }
        return result;
    }

    @Override
    public <T extends Content> boolean persist(T bean) {
        boolean result = this.persistUncommitted(bean);
        if (result) {
            this.commitTransaction();
        }
        return result;
    }

    protected <T extends Content> Class<T> getClassForName(String className) {
        Class result = null;
        for (Class<? extends Content> c : this.getClasses()) {
            if (!c.getName().equals(className)) continue;
            result = (Class)SystemUtils.convert(c);
        }
        if (result == null) {
            try {
                result = ClassResolver.loadClass((String)className);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("getClassForName()", (Throwable)cnfe);
            }
        }
        return result;
    }

    protected <T extends Content> Class<T> getKeyClass(String key) {
        String className = key.split(":")[0];
        LOG.debug("getKeyClass() {}", (Object)className);
        return this.getClassForName(className);
    }

    @Override
    public void clearCacheFor(Class<? extends Content> cls) {
        this.statistics.increase("bean cache clear");
        this.cache.clear();
        LOG.info("clearCacheFor() {}", (Object)cls.getName());
        try {
            HashSet<String> removeKeys = new HashSet<String>();
            Iterator<Object> i$ = this.queryCache.keySet().iterator();
            while (i$.hasNext()) {
                String string;
                String key = string = i$.next();
                Class c = this.getKeyClass(key);
                boolean assignableFrom = c.isAssignableFrom(cls);
                LOG.debug("clearCacheFor({}) {}? {}", new Object[]{key, c.getSimpleName(), assignableFrom});
                if (!assignableFrom) continue;
                removeKeys.add(key);
            }
            for (String string : removeKeys) {
                this.queryCache.remove(string);
            }
            this.startupCache.put(QUERY_CACHE_KEY, this.queryCache);
            for (Class clazz : this.getListeners().keySet()) {
                boolean assignableFrom = clazz.isAssignableFrom(cls);
                LOG.info("clearCacheFor() {}? {}", (Object)clazz.getSimpleName(), (Object)assignableFrom);
                if (!assignableFrom) continue;
                List<BeanListener> listeners = this.getListeners().get(clazz);
                if (LOG.isInfoEnabled()) {
                    LOG.info("clearCacheFor() triggering " + (listeners == null ? "no" : Integer.valueOf(listeners.size())) + " listeners");
                }
                if (listeners == null) continue;
                for (BeanListener listener : listeners) {
                    listener.reset();
                }
            }
        }
        catch (Exception e) {
            LOG.error("clearCacheFor() " + cls.getSimpleName(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Class<? extends Content> cls, BeanListener listener) {
        Map<Class<? extends Content>, List<BeanListener>> map = this.attachedListeners;
        synchronized (map) {
            List<BeanListener> listeners = this.attachedListeners.get(cls);
            if (listeners == null) {
                listeners = new ArrayList<BeanListener>();
                this.attachedListeners.put(cls, listeners);
            }
            listeners.add(listener);
        }
        LOG.info("addListener() {}: {}", (Object)cls.getSimpleName(), (Object)this.attachedListeners.get(cls).size());
    }

    protected <T extends Content> void filterExactClass(Class<T> cls, List<? extends Object> rawList, List<T> filteredList) {
        for (Object object : rawList) {
            Class<T> instanceClass = object.getClass();
            if (instanceClass.getName().startsWith("org.apache.openjpa.enhance")) {
                instanceClass = instanceClass.getSuperclass();
            }
            if (instanceClass.isAssignableFrom(cls)) {
                if (object instanceof BeanFactoryAware) {
                    ((BeanFactoryAware)object).setBeanFactory((BeanFactory)this);
                }
                filteredList.add((Content)object);
                continue;
            }
            LOG.warn("filterExactClass() class name of instance {}", (Object)object.getClass().getName());
        }
    }

    protected abstract <T extends Content> T getBean(Class<T> var1, String var2, String var3) throws Exception;

    public <T extends Content> T getBean(Class<T> cls, String id) {
        Object result;
        block6: {
            if (this.activateCaching && this.cache.containsKey(id)) {
                this.statistics.increase("get bean cached");
                return (T)((Content)SystemUtils.convert((Object)this.cache.get(id)));
            }
            result = null;
            try {
                String kind = null;
                String internalId = null;
                int idx = id.indexOf(58);
                if (idx > 0) {
                    kind = id.substring(0, idx);
                    internalId = id.substring(idx + 1);
                }
                if ((result = (Object)this.getBean(cls, kind, internalId)) instanceof BeanFactoryAware) {
                    ((BeanFactoryAware)result).setBeanFactory((BeanFactory)this);
                }
                if (this.activateCaching) {
                    this.cache.put(id, (Content)result);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block6;
                String simpleName = e.getClass().getSimpleName();
                LOG.warn("getBean() object not found for id '{}' {}: {}", new Object[]{id, simpleName, e.getLocalizedMessage(), e});
            }
        }
        this.statistics.increase("get bean uncached");
        return (T)result;
    }

    protected List<Class<? extends Content>> getImplementingClassesForModelClass(Class<? extends Content> baseClass) {
        ArrayList<Class<? extends Content>> result = new ArrayList<Class<? extends Content>>();
        for (Class<? extends Content> c : this.getClasses()) {
            if (!baseClass.isAssignableFrom(c)) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public Map<Class<? extends Content>, List<Class<? extends Content>>> getImplementingClassesMap() {
        if (this.implementingClassesMap == null) {
            this.implementingClassesMap = new HashMap<Class<? extends Content>, List<Class<? extends Content>>>();
            this.implementingClassesMap.put(this.getBaseClass(), this.getImplementingClassesForModelClass(this.getBaseClass()));
            this.implementingClassesMap.put(CodeResource.class, this.getImplementingClassesForModelClass(CodeResource.class));
            for (Class c : this.getAllClasses()) {
                this.implementingClassesMap.put(c, this.getImplementingClassesForModelClass(c));
            }
            LOG.info("getImplementingClassesMap() {}", this.implementingClassesMap);
        }
        return this.implementingClassesMap;
    }

    @Override
    public <T extends Content> List<Class<T>> getImplementingClasses(Class<T> baseClass) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (Class<? extends Content> c : this.getImplementingClassesMap().get(baseClass)) {
            result.add(c);
        }
        return result;
    }

    private <T> String getCacheKey(Class<T> cls, String queryString, String orderProperty, Boolean ascending) {
        return cls.getName() + ":" + orderProperty + ":" + (ascending == Boolean.TRUE ? "asc" : "desc") + ":" + queryString;
    }

    public <T extends Content> List<T> listBeans(Class<T> cls, String queryString, String orderProperty, Boolean ascending) {
        List<String> idList;
        ArrayList<T> result = null;
        if (LOG.isInfoEnabled()) {
            LOG.info("listBeans() looking up instances of " + cls.getSimpleName() + (queryString == null ? "" : " with condition " + queryString));
        }
        String key = null;
        if (this.isActivateQueryCaching() && (idList = this.queryCache.get(key = this.getCacheKey(cls, queryString, orderProperty, ascending))) != null) {
            LOG.info("listBeans() found in cache {}", idList);
            result = new ArrayList(idList.size());
            for (String id : idList) {
                result.add(this.getBean(cls, id));
            }
            this.statistics.increase("query beans cached");
        }
        if (result == null) {
            result = new ArrayList<T>();
            for (Class<? extends Content> cx : this.getClasses()) {
                if (!cls.isAssignableFrom(cx)) continue;
                Class c = (Class)SystemUtils.convert(cx);
                List beans = this.listBeansOfExactClass(c, queryString, orderProperty, ascending);
                result.addAll(beans);
            }
            if (this.isActivateQueryCaching()) {
                idList = new ArrayList<String>(result.size());
                for (Content content : result) {
                    idList.add(content.getId());
                }
                this.queryCache.put(key, idList);
                this.startupCache.put(QUERY_CACHE_KEY, this.queryCache);
            }
            this.statistics.increase("query beans uncached");
        }
        LOG.info("listBeans() looked up {} raw entries", (Object)result.size());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Class<? extends Content>> getClasses() {
        AbstractMutableBeanFactory abstractMutableBeanFactory = this;
        synchronized (abstractMutableBeanFactory) {
            if (this.modelClasses == null) {
                this.modelClasses = new ArrayList<Class<? extends Content>>();
                for (Class cls : this.getAllClasses()) {
                    if (cls.getAnnotation(Abstract.class) != null || cls == TransientCode.class || cls.isInterface() || (cls.getModifiers() & 0x400) != 0) continue;
                    this.modelClasses.add(cls);
                }
                Comparator comp = new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> o1, Class<?> o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                };
                Collections.sort(this.modelClasses, comp);
                this.tableNameMapping = new HashMap<String, Class<? extends Content>>();
                for (Class<? extends Content> mc : this.modelClasses) {
                    this.tableNameMapping.put(mc.getSimpleName(), mc);
                }
            }
        }
        return this.modelClasses;
    }
}

