/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components.mutable;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.annotate.LinkAction;
import org.tangram.annotate.LinkHandler;
import org.tangram.content.Content;
import org.tangram.link.LinkHandlerRegistry;
import org.tangram.monitor.Statistics;
import org.tangram.mutable.MutableBeanFactory;
import org.tangram.protection.AuthorizationService;
import org.tangram.view.TargetDescriptor;

@Named
@Singleton
@LinkHandler
public class ToolHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ToolHandler.class);
    @Inject
    private LinkHandlerRegistry registry;
    @Inject
    private Statistics statistics;
    @Inject
    private MutableBeanFactory beanFactory;
    @Inject
    private AuthorizationService authorizationService;

    @LinkAction(value="/clear/caches")
    public TargetDescriptor clearCaches(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.authorizationService.isAdminUser(request, response)) {
            return this.authorizationService.getLoginTarget(request);
        }
        LOG.info("clearCaches() clearing class specific caches");
        for (Class<? extends Content> c : this.beanFactory.getClasses()) {
            if (c.isInterface() || (c.getModifiers() & 0x400) > 0) {
                LOG.info("clearCaches() {} may not have instances", (Object)c.getSimpleName());
                continue;
            }
            this.beanFactory.clearCacheFor(c);
        }
        return new TargetDescriptor((Object)this.statistics, null, null);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.registry.registerLinkHandler((Object)this);
    }
}

