/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final DateFormat HTTP_HEADER_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    public static void setPrimaryBrowserLanguageForJstl(HttpServletRequest request) {
        String[] language;
        String[] acceptLanguage;
        String acceptLanguageHeader = request.getHeader("Accept-Language");
        if (acceptLanguageHeader == null) {
            return;
        }
        String[] acceptLanguages = acceptLanguageHeader.split(",");
        if (acceptLanguages.length > 0 && (acceptLanguage = acceptLanguages[0].split(";")).length > 0 && (language = acceptLanguage[0].split("-")).length > 0) {
            String localeCode = language[0];
            LOG.info("setPrimaryBrowserLanguageForJstl() setting request language {}", (Object)localeCode);
            Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)new Locale(localeCode));
        }
    }

    public static String urlize(String title) throws UnsupportedEncodingException {
        char[] specials;
        if (StringUtils.isEmpty((String)title)) {
            return "-";
        }
        String result = title.toLowerCase();
        result = result.replace(" - ", "-");
        result = result.replace("\u00e4", "ae");
        result = result.replace("\u00f6", "oe");
        result = result.replace("\u00fc", "ue");
        result = result.replace("\u00df", "ss");
        for (char c : specials = new char[]{',', ' ', ':', ';', '\"', '?', '!', '*', '\''}) {
            result = result.replace(c, '-');
        }
        return URLEncoder.encode(result, "UTF-8");
    }

    public static String getUriPrefix(String contextPath) {
        return contextPath.length() == 1 ? "" : contextPath;
    }

    public static String getUriPrefix(ServletContext context) {
        return Utils.getUriPrefix(context.getContextPath());
    }

    public static String getUriPrefix(HttpServletRequest request) {
        return Utils.getUriPrefix(request.getContextPath());
    }

    private Utils() {
    }

    static {
        HTTP_HEADER_DATE_FORMAT.setTimeZone(GMT);
    }
}

