/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferResponse
implements HttpServletResponse {
    private static final Logger LOG = LoggerFactory.getLogger(BufferResponse.class);
    private int bufferSize = 256;
    private ByteArrayOutputStream out;
    private ServletOutputStream stream;
    private PrintWriter writer;
    private String contentType = "text/html";
    private String encoding = "UTF-8";
    private Locale locale = Locale.getDefault();

    public BufferResponse() {
        this.reset();
    }

    public String getCharacterEncoding() {
        LOG.debug("getCharacterEncoding() {}", (Object)this.encoding);
        return this.encoding;
    }

    public String getContentType() {
        LOG.debug("getContentType() {}", (Object)this.contentType);
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        LOG.debug("getOutputStream() {}", (Object)this.stream);
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        LOG.debug("getWriter() {}", (Object)this.writer);
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        LOG.debug("setCharacterEncoding({})", (Object)charset);
        this.encoding = charset;
    }

    public void setContentLength(int len) {
        LOG.debug("setContentLength({})", (Object)len);
    }

    public void setContentType(String type) {
        LOG.debug("setContenType({})", (Object)type);
        this.contentType = type;
    }

    public void setBufferSize(int size) {
        LOG.debug("setBufferSize({})", (Object)size);
        this.bufferSize = size;
        this.reset();
    }

    public int getBufferSize() {
        LOG.debug("getBufferSize() {}", (Object)this.bufferSize);
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        LOG.debug("flushBuffer()");
        this.writer.flush();
        this.stream.flush();
        this.out.flush();
    }

    public void resetBuffer() {
        LOG.debug("resetBuffer()");
        this.reset();
    }

    public boolean isCommitted() {
        LOG.debug("isCommitted()");
        return false;
    }

    public final void reset() {
        LOG.debug("reset()");
        this.out = new ByteArrayOutputStream(this.bufferSize);
        this.stream = new ServletOutputStreamWrapper(this.out);
        this.writer = new PrintWriter((OutputStream)this.stream);
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getContents() throws UnsupportedEncodingException, IOException {
        return new String(this.getBytes());
    }

    public byte[] getBytes() throws UnsupportedEncodingException, IOException {
        this.flushBuffer();
        this.out.close();
        return this.out.toByteArray();
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException("NYI");
    }

    public boolean containsHeader(String name) {
        throw new UnsupportedOperationException("NYI");
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException("NYI");
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException("NYI");
    }

    @Deprecated
    public String encodeUrl(String url) {
        throw new UnsupportedOperationException("NYI");
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException("NYI");
    }

    public void sendError(int sc, String msg) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    public void sendError(int sc) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    public void sendRedirect(String location) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    public void setDateHeader(String name, long date) {
        throw new UnsupportedOperationException("NYI");
    }

    public void addDateHeader(String name, long date) {
        throw new UnsupportedOperationException("NYI");
    }

    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException("NYI");
    }

    public void addHeader(String name, String value) {
        throw new UnsupportedOperationException("NYI");
    }

    public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException("NYI");
    }

    public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException("NYI");
    }

    public void setStatus(int sc) {
        throw new UnsupportedOperationException("NYI");
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        throw new UnsupportedOperationException("NYI");
    }

    public int getStatus() {
        throw new UnsupportedOperationException("NYI");
    }

    public String getHeader(String string) {
        throw new UnsupportedOperationException("NYI");
    }

    public Collection<String> getHeaders(String string) {
        throw new UnsupportedOperationException("NYI");
    }

    public Collection<String> getHeaderNames() {
        throw new UnsupportedOperationException("NYI");
    }

    public void setContentLengthLong(long l) {
        throw new UnsupportedOperationException("NYI");
    }

    private class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private final ByteArrayOutputStream out;

        public ServletOutputStreamWrapper(ByteArrayOutputStream o) {
            this.out = o;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener wl) {
            throw new UnsupportedOperationException("NYI");
        }
    }
}

