/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.BeanListener;
import org.tangram.content.CodeResource;
import org.tangram.content.CodeResourceCache;
import org.tangram.view.AbstractTemplateResolver;
import org.tangram.view.TemplateResolver;

public abstract class AbstractRepositoryTemplateResolver<T>
extends AbstractTemplateResolver<T>
implements BeanListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRepositoryTemplateResolver.class);
    @Inject
    private CodeResourceCache codeResourceCache;
    private final Collection<String> supportedContentTypes = new HashSet<String>();

    public AbstractRepositoryTemplateResolver() {
        super(false, ".");
        this.supportedContentTypes.add("text/html");
        this.supportedContentTypes.add("application/xml");
        this.supportedContentTypes.add("image/svg+xml");
    }

    @Override
    protected T checkResourceExists(T view) {
        return view;
    }

    protected CodeResource resolveTemplate(String path, Locale locale) throws Exception {
        CodeResource template = null;
        for (String type : this.supportedContentTypes) {
            if (template != null) continue;
            template = this.codeResourceCache.get(type, path);
        }
        return template;
    }

    @Override
    public void reset() {
        this.getCache().clear();
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet()");
        this.codeResourceCache.addListener(this);
    }

    @Override
    public int compareTo(TemplateResolver<T> o) {
        return -1;
    }
}

