/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.BeanFactory;
import org.tangram.content.Content;
import org.tangram.content.Markdown;
import org.tangram.util.SystemUtils;
import org.tangram.view.BufferResponse;
import org.tangram.view.PropertyConverter;
import org.tangram.view.ViewUtilities;

public abstract class AbstractPropertyConverter
implements PropertyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertyConverter.class);
    private DateFormat dateFormat = new SimpleDateFormat("kk:mm:ss dd.MM.yyyy zzz");
    @Inject
    private BeanFactory<?> beanFactory;
    @Inject
    private ViewUtilities viewUtilties;

    public void setDateFormat(String dateFormat) {
        this.dateFormat = new SimpleDateFormat(dateFormat);
    }

    @Override
    public String getEditString(Object o) {
        try {
            if (o == null) {
                return "";
            }
            if (o instanceof List) {
                StringBuilder result = new StringBuilder("");
                try {
                    List list = (List)o;
                    for (Object i : list) {
                        if (i instanceof Content) {
                            result.append(((Content)i).getId());
                            result.append(", ");
                            continue;
                        }
                        result.append(i);
                        result.append(',');
                    }
                }
                catch (Exception ex) {
                    LOG.error("getEditString() Loss of references on editing a list. Be warned and check your content.", (Throwable)ex);
                }
                return result.toString();
            }
            if (o instanceof Boolean) {
                return o.toString();
            }
            if (o instanceof Content) {
                return ((Content)o).getId();
            }
            if (o instanceof Date) {
                return this.dateFormat.format(o);
            }
            return o.toString();
        }
        catch (Exception e) {
            LOG.error("getEditString()", (Throwable)e);
            return "error while converting " + o;
        }
    }

    private <T extends Content> List<T> getObjectsViaDescription(Class<T> c, String title, ServletRequest request) {
        ArrayList<Content> result = new ArrayList<Content>();
        if (StringUtils.isNotBlank((String)title)) {
            List beans = this.beanFactory.listBeans(c);
            LOG.debug("getObjectsViaDescription({} :{}) checking {}", new Object[]{title, c.getSimpleName(), beans});
            for (Content bean : beans) {
                try {
                    LOG.debug("getObjectsViaDescription() checking bean {}", (Object)bean);
                    BufferResponse r = new BufferResponse();
                    this.viewUtilties.render(r.getWriter(), bean, "description", request, (ServletResponse)r);
                    String description = r.getContents();
                    LOG.debug("getObjectsViaDescription({}) {} has description {}", new Object[]{description.indexOf(title), bean, description});
                    if (!description.contains(title)) continue;
                    result.add(bean);
                }
                catch (IOException ioe) {
                    LOG.error("getObjectsViaDescription() ignoring element " + bean, (Throwable)ioe);
                }
            }
        }
        LOG.debug("getObjectsViaDescription({}) result={}", (Object)title, result);
        return result;
    }

    private <T extends Content> T getObjectViaDescription(Class<T> c, String title, ServletRequest request) {
        Content result = null;
        List<T> suggestions = this.getObjectsViaDescription(c, title, request);
        if (suggestions.size() == 1) {
            result = (Content)suggestions.get(0);
        }
        return (T)result;
    }

    private Matcher createIdMatcher(String idString) {
        return Pattern.compile("([A-Z][a-zA-Z]+:[0-9a-f]+)").matcher(idString);
    }

    private Content getReferenceValue(Class<? extends Content> cls, ServletRequest request, String valueString) {
        Content value;
        Matcher m = this.createIdMatcher(valueString);
        if (m.find()) {
            valueString = m.group(1);
            LOG.info("getReferenceValue() pattern match result {}", (Object)valueString);
            value = this.beanFactory.getBean(valueString);
        } else {
            LOG.warn("getReferenceValue() we should have checked for selection via description template");
            value = this.getObjectViaDescription(cls, valueString.trim(), request);
            if (value != null) {
                LOG.info("getReferenceValue() found a value from description {}", (Object)value);
            }
        }
        return value;
    }

    @Override
    public Object getStorableObject(Content client, String valueString, Class<? extends Object> cls, Type type, ServletRequest request) {
        ArrayList<Object> value = null;
        if (valueString != null) {
            LOG.debug("getStorableObject() required type is {}", (Object)cls.getName());
            if (cls == String.class) {
                value = StringUtils.isNotBlank((String)valueString) ? valueString : null;
            } else if (cls == Date.class) {
                try {
                    value = this.dateFormat.parseObject(valueString);
                }
                catch (ParseException pe) {
                    LOG.error("getStorableObject() cannot parse as Date: " + valueString);
                }
            } else if (cls == Long.class) {
                value = StringUtils.isNotBlank((String)valueString) ? Long.valueOf(Long.parseLong(valueString)) : null;
            } else if (cls == Integer.class) {
                value = StringUtils.isNotBlank((String)valueString) ? Integer.valueOf(Integer.parseInt(valueString)) : null;
            } else if (cls == Float.class) {
                value = StringUtils.isNotBlank((String)valueString) ? Float.valueOf(Float.parseFloat(valueString)) : null;
            } else if (cls == Boolean.class) {
                value = Boolean.parseBoolean(valueString);
            } else if (cls == Markdown.class) {
                value = new Markdown(valueString.toCharArray());
            } else if (cls == List.class) {
                LOG.debug("getStorableObject() splitting {}", (Object)valueString);
                String[] commaSeparated = valueString.split(",");
                ArrayList<Object> elements = new ArrayList<Object>();
                ParameterizedType parameterizedType = type instanceof ParameterizedType ? (ParameterizedType)type : null;
                Class elementClass = Content.class;
                if (parameterizedType != null && parameterizedType.getActualTypeArguments().length == 1) {
                    Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
                    LOG.debug("getStorableObject() actualTypeArgument={}", (Object)actualTypeArgument);
                    if (actualTypeArgument instanceof Class) {
                        elementClass = (Class)SystemUtils.convert(actualTypeArgument);
                    }
                }
                for (String oneValuString : commaSeparated) {
                    oneValuString = oneValuString.trim();
                    LOG.debug("getStorableObject() idString={}", (Object)oneValuString);
                    if (!StringUtils.isNotBlank((String)oneValuString)) continue;
                    if (Content.class.isAssignableFrom(elementClass)) {
                        Matcher m = this.createIdMatcher(oneValuString);
                        if (m.find()) {
                            oneValuString = m.group(1);
                            Content bean = this.beanFactory.getBean(oneValuString);
                            LOG.info("getStorableObject() pattern match result {} ({})", (Object)oneValuString, (Object)bean);
                            if (bean == null || client != null && bean.getId().equals(client.getId()) || !elementClass.isAssignableFrom(bean.getClass())) continue;
                            elements.add(bean);
                            continue;
                        }
                        LOG.debug("getStorableObject() parameterizedType={}", (Object)parameterizedType);
                        List results = this.getObjectsViaDescription(elementClass, oneValuString, request);
                        if (results.isEmpty()) continue;
                        elements.addAll(results);
                        continue;
                    }
                    elements.add(this.getStorableObject(client, oneValuString, elementClass, request));
                }
                value = elements;
            } else if (Content.class.isAssignableFrom(cls)) {
                Class cc = (Class)SystemUtils.convert(cls);
                Content referenceValue = this.getReferenceValue(cc, request, valueString);
                value = client != null && client.equals(referenceValue) ? null : referenceValue;
            }
        }
        return value;
    }

    @Override
    public Object getStorableObject(Content client, String valueString, Class<? extends Object> cls, ServletRequest request) {
        return this.getStorableObject(client, valueString, cls, null, request);
    }

    @Override
    public abstract boolean isBlobType(Class<?> var1);

    @Override
    public abstract long getBlobLength(Object var1);

    @Override
    public abstract boolean isTextType(Class<?> var1);

    @Override
    public abstract Object createBlob(byte[] var1);
}

