/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.controller;

import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.controller.ControllerHook;
import org.tangram.link.Link;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.link.TargetDescriptor;

public class UniqueHostHook
implements ControllerHook {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueHostHook.class);
    @Inject
    private LinkFactoryAggregator linkFactoryAggregator;
    private String primaryDomain = null;

    public void setPrimaryDomain(String primaryDomain) {
        this.primaryDomain = primaryDomain;
    }

    @Override
    public boolean intercept(TargetDescriptor descriptor, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isOnLocalhost = request.getServerName().equals("localhost");
        LOG.debug("intercept() serverName={} isOnLocalhost={}", (Object)request.getServerName(), (Object)isOnLocalhost);
        if (isOnLocalhost || !request.getServerName().equals(this.primaryDomain)) {
            Link redirectLink = this.linkFactoryAggregator.createLink(request, response, descriptor.bean, descriptor.action, descriptor.view);
            response.setHeader("Location", "http://" + this.primaryDomain + redirectLink.getUrl());
            response.setStatus(301);
            return true;
        }
        return false;
    }
}

