/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.controller;

import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.BeanFactory;
import org.tangram.controller.ControllerHook;
import org.tangram.link.Link;
import org.tangram.link.LinkFactory;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.link.LinkHandlerRegistry;
import org.tangram.link.TargetDescriptor;
import org.tangram.view.ViewContextFactory;

public abstract class AbstractLinkHandler
implements LinkFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLinkHandler.class);
    @Inject
    protected BeanFactory<?> beanFactory;
    @Inject
    protected ViewContextFactory viewContextFactory;
    private LinkFactoryAggregator linkFactory;
    @Inject
    private Set<ControllerHook> controllerHooks;
    @Inject
    private LinkHandlerRegistry linkHandlerRegistry;

    public BeanFactory<?> getBeanFactory() {
        return this.beanFactory;
    }

    public LinkFactoryAggregator getLinkFactory() {
        return this.linkFactory;
    }

    @Inject
    public void setLinkFactory(LinkFactoryAggregator linkFactory) {
        this.linkFactory = linkFactory;
        this.linkFactory.registerFactory(this);
    }

    protected Map<String, Object> createModel(TargetDescriptor descriptor, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> model = this.viewContextFactory.createModel(descriptor.bean, (ServletRequest)request, (ServletResponse)response);
        for (ControllerHook controllerHook : this.controllerHooks) {
            LOG.debug("createModel() {}", (Object)controllerHook.getClass().getName());
            boolean result = controllerHook.intercept(descriptor, model, request, response);
            if (!result) continue;
            return null;
        }
        return model;
    }

    @Override
    public abstract Link createLink(HttpServletRequest var1, HttpServletResponse var2, Object var3, String var4, String var5);

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet() {}", (Object)this.getClass().getSimpleName());
        this.linkHandlerRegistry.registerLinkHandler(this);
    }
}

