/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.content;

import com.github.rjeschke.txtmark.Processor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.tangram.content.CodeResource;
import org.tangram.content.Content;

public class TransientCode
implements CodeResource,
Serializable {
    private static final long serialVersionUID = -4573161886986101943L;
    private final String annotation;
    private final String mimeType;
    private final String codeText;
    private final long modificationTime;
    private final String id;

    public TransientCode(String annotation, String mimeType, String id, String codeText, long modificationTime) {
        this.annotation = annotation;
        boolean md = "text/x-markdown".equals(mimeType);
        this.codeText = md ? Processor.process((String)codeText) : codeText;
        this.mimeType = md ? "text/html" : mimeType;
        this.modificationTime = modificationTime;
        this.id = id;
    }

    public TransientCode(CodeResource code) {
        this(code.getAnnotation(), code.getMimeType(), code.getId(), code.getCodeText(), code.getModificationTime());
    }

    @Override
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public String getCodeText() {
        return this.codeText;
    }

    @Override
    public long getSize() {
        return this.getCodeText().length();
    }

    @Override
    public InputStream getStream() throws Exception {
        return new ByteArrayInputStream(this.getCodeText().getBytes("UTF-8"));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(Content o) {
        return o instanceof TransientCode ? (this.getMimeType() + this.getAnnotation()).compareTo(((CodeResource)o).getMimeType() + ((CodeResource)o).getAnnotation()) : -1;
    }

    public String toString() {
        return this.getAnnotation() + " (" + this.getMimeType() + ")";
    }
}

