/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.BeanFactory;
import org.tangram.content.Content;
import org.tangram.controller.ControllerHook;
import org.tangram.link.TargetDescriptor;
import org.tangram.protection.ProtectedContent;
import org.tangram.protection.Protection;

@Named
@Singleton
public class ProtectionHook
implements ControllerHook {
    private static final Logger LOG = LoggerFactory.getLogger(ProtectionHook.class);
    @Inject
    private BeanFactory<?> beanFactory;

    public Map<String, Protection> getRequiredProtections(ProtectedContent content) {
        Map<String, Protection> result = Collections.emptyMap();
        if (content instanceof Protection) {
            result = new HashMap();
            Protection prot = (Protection)content;
            result.put(prot.getProtectionKey(), prot);
        } else {
            List protections = this.beanFactory.listBeans(Protection.class);
            LOG.info("getRequiredProtections() total # of protections: {}", (Object)protections.size());
            if (protections.size() > 0) {
                result = new HashMap<String, Protection>();
                for (Protection prot : protections) {
                    if (!StringUtils.isNotBlank((String)prot.getProtectionKey()) || !this.isProtectedBy(content, prot)) continue;
                    result.put(prot.getProtectionKey(), prot);
                }
            }
        }
        return result;
    }

    private String getFailingProtectionKey(HttpServletRequest request, Map<String, Protection> protections) throws Exception {
        for (Protection p : protections.values()) {
            if (p.isContentVisible(request)) continue;
            return p.getProtectionKey();
        }
        return null;
    }

    public boolean isProtectedBy(ProtectedContent protectedContent, Protection p) {
        boolean result = false;
        List<? extends Content> path = protectedContent.getProtectionPath();
        try {
            List<? extends Content> protectedContents = p.getProtectedContents();
            if (protectedContents != null) {
                for (Content content : protectedContents) {
                    if (!path.contains(content)) continue;
                    result = true;
                }
            }
        }
        catch (Exception e) {
            LOG.error("isProtectedBy(" + protectedContent.getId() + ") " + p.getId(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean intercept(TargetDescriptor descriptor, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Protection protection = null;
        String loginResult = null;
        if (descriptor.bean instanceof ProtectedContent) {
            String necessaryProtectionKey;
            ProtectedContent protectedContent = (ProtectedContent)descriptor.bean;
            Map<String, Protection> protections = this.getRequiredProtections(protectedContent);
            LOG.info("render() # of relevant protections: {}", (Object)protections.size());
            String protectionKey = request.getParameter("protection.key");
            if (protectionKey != null && "POST".equals(request.getMethod())) {
                LOG.info("render() handling login {} for topic {}", (Object)protectionKey, (Object)protectedContent.getId());
                loginResult = protections.get(protectionKey).handleLogin(request, response);
            }
            if ((necessaryProtectionKey = this.getFailingProtectionKey(request, protections)) != null) {
                LOG.info("render() topic {} is not visible", (Object)protectedContent.getId());
                for (Protection p : protections.values()) {
                    if (!p.needsAuthorization(request)) continue;
                    LOG.info("render() Protection specific authorization necessary: {}", (Object)p.getProtectionKey());
                    protection = p;
                }
                if (protection == null && (necessaryProtectionKey = this.getFailingProtectionKey(request, protections)) != null) {
                    response.sendError(403, necessaryProtectionKey);
                    return true;
                }
            }
        }
        model.put("protection", protection);
        model.put("loginResult", loginResult);
        return false;
    }
}

