/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.oauth.profile.google2.Google2Email;
import org.pac4j.oauth.profile.google2.Google2Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.annotate.LinkAction;
import org.tangram.annotate.LinkHandler;
import org.tangram.annotate.LinkPart;
import org.tangram.authentication.AuthenticationService;
import org.tangram.authentication.GenericUser;
import org.tangram.authentication.User;
import org.tangram.link.Link;
import org.tangram.link.LinkFactory;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.link.LinkHandlerRegistry;
import org.tangram.link.TargetDescriptor;
import org.tangram.util.SystemUtils;

@LinkHandler
@Named(value="authenticationService")
@Singleton
public class PacAuthenticationService
implements AuthenticationService,
LinkFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PacAuthenticationService.class);
    @Inject
    @Named(value="loginProviders")
    @Resource(name="loginProviders")
    private Set<String> loginProviders;
    @Inject
    @Named(value="userIdAttributes")
    @Resource(name="userIdAttributes")
    private Map<String, String> userIdAttributes;
    @Inject
    private Set<Client> clientSet = new HashSet<Client>();
    @Inject
    private LinkHandlerRegistry registry;
    @Inject
    private LinkFactoryAggregator linkFactoryAggregator;
    private Clients clients = null;

    @Override
    public Set<String> getProviderNames() {
        HashSet<String> providerNames = new HashSet<String>();
        LOG.info("getProviderNames() login providers {}", this.loginProviders);
        LOG.debug("getProviderNames() client set {}", this.clientSet);
        for (Client client : this.clientSet) {
            if (!this.loginProviders.contains(client.getName())) continue;
            providerNames.add(client.getName());
        }
        LOG.info("getProviderNames() provider names {}", providerNames);
        return providerNames;
    }

    private String getLoginAction(Set<String> providers) {
        LOG.debug("getLoginAction() {}", providers);
        HashSet<String> availableProviders = new HashSet<String>();
        for (String provider : this.getProviderNames()) {
            if (!providers.contains(provider)) continue;
            availableProviders.add(provider);
        }
        LOG.debug("getLoginAction() {}", availableProviders);
        return availableProviders.size() == 1 ? (String)availableProviders.iterator().next() : "login";
    }

    @Override
    public TargetDescriptor getLoginTarget(Set<String> providers) {
        return new TargetDescriptor(this, null, this.getLoginAction(providers));
    }

    @Override
    public Link getLogoutLink(HttpServletRequest request, HttpServletResponse response) {
        return this.linkFactoryAggregator.createLink(request, response, this, "logout", null);
    }

    @Override
    public void redirectToLogin(HttpServletRequest request, HttpServletResponse response, Set<String> providers) throws IOException {
        Link link = this.linkFactoryAggregator.createLink(request, response, this, this.getLoginAction(providers), null);
        response.sendRedirect(link.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Clients getClients(HttpServletRequest request, HttpServletResponse response) {
        PacAuthenticationService pacAuthenticationService = this;
        synchronized (pacAuthenticationService) {
            if (this.clients == null) {
                ArrayList<Client> clientList = new ArrayList<Client>(this.clientSet);
                String callbackUri = this.linkFactoryAggregator.createLink(request, response, this, "callback", null).getUrl();
                String callbackUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + callbackUri;
                LOG.info("getClients() callback url {}", (Object)callbackUrl);
                this.clients = new Clients(callbackUrl, clientList);
                try {
                    FormClient formClient = (FormClient)this.clients.findClient(FormClient.class);
                    Link loginLink = this.linkFactoryAggregator.createLink(request, response, this, "login-form", null);
                    LOG.debug("getClients() login link {}", (Object)loginLink);
                    formClient.setLoginUrl(loginLink.getUrl());
                }
                catch (Exception e) {
                    String simpleName = e.getClass().getSimpleName();
                    LOG.warn("getClients() {} :{}", (Object)e.getMessage(), (Object)simpleName);
                }
            }
        }
        return this.clients;
    }

    @Override
    public Set<User> getUsers(HttpServletRequest request, HttpServletResponse response) {
        Set<User> result = new HashSet<User>();
        HttpSession session = request.getSession(false);
        LOG.debug("getUsers() session: {}", (Object)session);
        if (session != null) {
            LOG.debug("getUsers() session id: {}", (Object)session.getId());
            Object users = session.getAttribute("tangram.users");
            LOG.info("getUsers({}) users: {}", (Object)session.getId(), users);
            if (users != null) {
                result = (Set)SystemUtils.convert(users);
            }
        }
        return result;
    }

    @LinkAction(value="/login")
    public TargetDescriptor login(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("login()");
        response.setContentType("text/html; charset=UTF-8");
        return new TargetDescriptor(this, null, null);
    }

    @LinkAction(value="/login-form")
    public TargetDescriptor form(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("form()");
        response.setContentType("text/html; charset=UTF-8");
        return new TargetDescriptor(this, "form", null);
    }

    private TargetDescriptor getReturnTarget() {
        return new TargetDescriptor(this, null, "return");
    }

    @LinkAction(value="/logout")
    public TargetDescriptor logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("logout()");
        Object returnUrl = request.getSession(true).getAttribute("tangram.return.url");
        request.getSession(true).invalidate();
        request.getSession(true).setAttribute("tangram.return.url", returnUrl);
        return this.getReturnTarget();
    }

    @LinkAction(value="/redirect/(.*)")
    public TargetDescriptor redirect(@LinkPart(value=1) String provider, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("redirect()");
        J2EContext context = new J2EContext(request, response);
        Client client = this.getClients(request, response).findClient(provider);
        LOG.info("redirect() redirecting with {}", (Object)client.getName());
        client.redirect((WebContext)context);
        return TargetDescriptor.DONE;
    }

    @LinkAction(value="/callback")
    public TargetDescriptor callback(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("callback()");
        HttpSession session = request.getSession(true);
        HashSet<GenericUser> users = (HashSet<GenericUser>)SystemUtils.convert(session.getAttribute("tangram.users"));
        LOG.info("callback() logged in users {}", (Object)users);
        if (users == null) {
            users = new HashSet<GenericUser>();
            session.setAttribute("tangram.users", users);
        }
        J2EContext context = new J2EContext(request, response);
        Client client = (Client)SystemUtils.convert(this.getClients(request, response).findClient((WebContext)context));
        LOG.info("callback() client: {}", (Object)client);
        try {
            Credentials credentials = client.getCredentials((WebContext)context);
            LOG.info("callback() credentials: {}", (Object)credentials);
            CommonProfile userProfile = client.getUserProfile(credentials, (WebContext)context);
            HashMap<String, Object> attributes = new HashMap<String, Object>(userProfile.getAttributes());
            if (userProfile instanceof Google2Profile) {
                Google2Profile gp = (Google2Profile)userProfile;
                for (Google2Email em : gp.getEmails()) {
                    LOG.debug("callback() google mail: {}", (Object)em.getEmail());
                    attributes.put("email", em.getEmail());
                }
            }
            LOG.debug("callback() userProfile {}: {} ({})", new Object[]{userProfile.getId(), userProfile, request.getSession(false)});
            String idAttribute = this.userIdAttributes.get(client.getName());
            String userId = StringUtils.isEmpty((String)idAttribute) ? userProfile.getId() : "" + attributes.get(idAttribute);
            LOG.debug("callback() user id : {} ({})", (Object)userId, (Object)idAttribute);
            GenericUser user = new GenericUser(client.getName(), userId, attributes);
            if (!users.contains(user)) {
                users.add(user);
            }
            LOG.info("callback({}) logged in users after callback {}", (Object)session.getId(), users);
        }
        catch (RuntimeException e) {
            LOG.warn("callback()", (Object)e.getLocalizedMessage());
            session.setAttribute("tangram.login.error", (Object)e.getLocalizedMessage());
            return new TargetDescriptor(this, null, client.getName());
        }
        return this.getReturnTarget();
    }

    @Override
    public Link createLink(HttpServletRequest request, HttpServletResponse response, Object bean, String action, String view) {
        Link result = null;
        if (bean == this) {
            if ("form".equals(view)) {
                result = new Link("/login-form");
            } else {
                Set<String> providerNames = this.getProviderNames();
                LOG.info("createLink() creating login handling url for action {} in {}", (Object)action, providerNames);
                if ("return".equals(action)) {
                    HttpSession session = request.getSession(true);
                    Object returnUrl = session.getAttribute("tangram.return.url");
                    if (returnUrl != null) {
                        LOG.info("createLink() creating return link to {}", returnUrl);
                        result = new Link(returnUrl.toString().substring(this.linkFactoryAggregator.getPrefix(request).length()));
                        session.removeAttribute("tangramURL");
                    } else {
                        result = new Link("/");
                    }
                } else {
                    result = providerNames.contains(action) ? new Link("/redirect/" + action) : new Link("/" + (action == null ? "login" : action));
                }
                LOG.info("createLink() creating login handling url for action {} in {}: {}", new Object[]{action, providerNames, result});
            }
        }
        return result;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet() registering handler");
        this.registry.registerLinkHandler(this);
        this.linkFactoryAggregator.registerFactory(this);
        LOG.debug("afterPropertiesSet() collecting clients");
        for (Client client : this.clientSet) {
            LOG.info("afterPropertiesSet() client {}", (Object)client.getName());
        }
    }
}

