/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.annotate.ActionForm;
import org.tangram.annotate.ActionParameter;
import org.tangram.annotate.LinkAction;
import org.tangram.annotate.LinkHandler;
import org.tangram.annotate.LinkPart;
import org.tangram.content.BeanFactory;
import org.tangram.content.BeanFactoryAware;
import org.tangram.content.BeanListener;
import org.tangram.controller.ControllerHook;
import org.tangram.link.Link;
import org.tangram.link.LinkFactory;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.link.LinkHandlerRegistry;
import org.tangram.link.TargetDescriptor;
import org.tangram.logic.ClassRepository;
import org.tangram.util.JavaBean;
import org.tangram.view.PropertyConverter;
import org.tangram.view.RequestParameterAccess;
import org.tangram.view.Utils;
import org.tangram.view.ViewContext;
import org.tangram.view.ViewContextFactory;
import org.tangram.view.ViewUtilities;

@Named
@Singleton
public class MetaLinkHandler
implements LinkHandlerRegistry,
LinkFactory,
BeanListener {
    private static final Logger LOG = LoggerFactory.getLogger(MetaLinkHandler.class);
    @Inject
    private BeanFactory<?> beanFactory;
    @Inject
    private ClassRepository classRepository;
    @Inject
    private ViewUtilities viewUtilities;
    @Inject
    private ViewContextFactory viewContextFactory;
    @Inject
    private LinkFactoryAggregator linkFactoryAggregator;
    @Inject
    private Set<ControllerHook> controllerHooks;
    @Inject
    private PropertyConverter propertyConverter;
    private final Map<String, org.tangram.link.LinkHandler> staticLinkHandlers = new HashMap<String, org.tangram.link.LinkHandler>();
    private Map<String, org.tangram.link.LinkHandler> handlers;
    private final Map<Pattern, Method> staticMethods = new HashMap<Pattern, Method>();
    private Map<Pattern, Method> methods;
    private final Map<Pattern, Object> staticAtHandlers = new HashMap<Pattern, Object>();
    private Map<Pattern, Object> atHandlers;

    private Map<String, Object> createModel(TargetDescriptor descriptor, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> model = this.viewContextFactory.createModel(descriptor.bean, (ServletRequest)request, (ServletResponse)response);
        for (ControllerHook controllerHook : this.controllerHooks) {
            LOG.debug("createModel() {}", (Object)controllerHook.getClass().getName());
            boolean result = controllerHook.intercept(descriptor, model, request, response);
            if (!result) continue;
            return null;
        }
        return model;
    }

    private TargetDescriptor callAction(HttpServletRequest request, HttpServletResponse response, Matcher matcher, Method method, TargetDescriptor descriptor, Object target) throws Throwable, IllegalAccessException {
        TargetDescriptor result = null;
        LOG.debug("callAction() {} @ {}", (Object)method, target);
        if (method != null) {
            descriptor.action = null;
            ArrayList<Object> parameters = new ArrayList<Object>();
            Annotation[][] allAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            RequestParameterAccess parameterAccess = this.viewUtilities.createParameterAccess(request);
            for (int typeIndex = 0; typeIndex < parameterTypes.length; ++typeIndex) {
                Annotation[] annotations = allAnnotations[typeIndex];
                Class<?> type = parameterTypes[typeIndex];
                Type genericType = genericParameterTypes[typeIndex];
                if (type.equals(HttpServletRequest.class)) {
                    parameters.add(request);
                }
                if (type.equals(HttpServletResponse.class)) {
                    parameters.add(response);
                }
                for (Annotation annotation : annotations) {
                    if (annotation instanceof LinkPart) {
                        String valueString = matcher.group(((LinkPart)annotation).value());
                        LOG.debug("callAction() parameter #{}='{}' should be of type {}", new Object[]{typeIndex, valueString, type.getName()});
                        parameters.add(this.propertyConverter.getStorableObject(null, valueString, type, genericType, (ServletRequest)request));
                    }
                    if (annotation instanceof ActionParameter) {
                        String parameterName = ((ActionParameter)annotation).value();
                        if ("--empty--".equals(parameterName)) {
                            parameterName = type.getSimpleName().toLowerCase();
                        }
                        LOG.debug("callAction() parameter {} should be of type {} {}", new Object[]{parameterName, type.getSimpleName(), type.getName()});
                        boolean isBlob = "byte[]".equals(type.getSimpleName());
                        byte[] value = isBlob ? parameterAccess.getData(parameterName) : (byte[])this.propertyConverter.getStorableObject(null, request.getParameter(parameterName), type, genericType, (ServletRequest)request);
                        parameters.add(value);
                    }
                    if (!(annotation instanceof ActionForm)) continue;
                    try {
                        Object form = type.newInstance();
                        JavaBean wrapper = new JavaBean(form);
                        for (String propertyName : wrapper.propertyNames()) {
                            String valueString = request.getParameter(propertyName);
                            Class<? extends Object> t = wrapper.getType(propertyName);
                            Type gt = wrapper.getGenericType(propertyName);
                            boolean isBlob = "byte[]".equals(t.getSimpleName());
                            byte[] value = isBlob ? parameterAccess.getData(propertyName) : (byte[])this.propertyConverter.getStorableObject(null, valueString, t, gt, (ServletRequest)request);
                            wrapper.set(propertyName, value);
                        }
                        parameters.add(form);
                    }
                    catch (Exception e) {
                        LOG.error("callAction() cannot create and fill form " + type.getName(), (Throwable)e);
                    }
                }
            }
            LOG.info("callAction() calling method {} with {} parameters", (Object)method.getName(), (Object)parameters.size());
            try {
                descriptor = (TargetDescriptor)method.invoke(target, parameters.toArray());
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            LOG.info("callAction() result is {}", (Object)descriptor);
            result = descriptor;
        }
        LOG.info("callAction() link={}", result);
        return result;
    }

    private ViewContext handleResultDescriptor(TargetDescriptor resultDescriptor, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ViewContext result = null;
        if (resultDescriptor != null && resultDescriptor != TargetDescriptor.DONE) {
            LOG.info("handleResultDescriptor() received link {}", (Object)resultDescriptor);
            if (resultDescriptor.action != null) {
                try {
                    Link link = this.linkFactoryAggregator.createLink(request, response, resultDescriptor.bean, resultDescriptor.action, resultDescriptor.view);
                    response.sendRedirect(link.getUrl());
                }
                catch (Exception e) {
                    LOG.error("handleResultDescriptor()", (Throwable)e);
                    result = this.viewContextFactory.createViewContext(resultDescriptor.bean, resultDescriptor.view, (ServletRequest)request, (ServletResponse)response);
                }
            } else {
                Map<String, Object> model = this.createModel(resultDescriptor, request, response);
                result = this.viewContextFactory.createViewContext(model, resultDescriptor.view);
            }
        }
        return result;
    }

    private void registerAtHandler(Class<? extends Object> handlerClass, Object handler, boolean immutable) throws SecurityException {
        if (handlerClass.getAnnotation(LinkHandler.class) != null) {
            for (Method m : handlerClass.getMethods()) {
                LinkAction linkAction = m.getAnnotation(LinkAction.class);
                LOG.debug("registerAtHandler({}) linkAction={}", (Object)handlerClass.getName(), (Object)linkAction);
                LOG.debug("registerAtHandler() {} :{}", (Object)m.getName(), m.getReturnType());
                if (!TargetDescriptor.class.equals(m.getReturnType())) {
                    linkAction = null;
                }
                if (linkAction == null || !StringUtils.isNotBlank((String)linkAction.value())) continue;
                Pattern pathPattern = Pattern.compile(linkAction.value().replace("/", "\\/"));
                LOG.info("registerAtHandler() registering {} for {}@{}", new Object[]{pathPattern, m.getName(), handler});
                this.methods.put(pathPattern, m);
                this.atHandlers.put(pathPattern, handler);
                if (!immutable) continue;
                if (!this.staticMethods.containsKey(pathPattern)) {
                    this.staticMethods.put(pathPattern, m);
                }
                if (this.staticAtHandlers.containsKey(pathPattern)) continue;
                this.staticAtHandlers.put(pathPattern, handler);
            }
        }
    }

    private void registerInterfaceHandler(org.tangram.link.LinkHandler handler, boolean immutable) {
        this.handlers.put(handler.getClass().getName(), handler);
        if (immutable) {
            this.staticLinkHandlers.put(handler.getClass().getName(), handler);
        }
    }

    private void registerLinkHandler(Object handler, boolean isAnnotated, boolean immutable) {
        if (handler instanceof BeanFactoryAware) {
            ((BeanFactoryAware)handler).setBeanFactory(this.beanFactory);
        }
        if (handler instanceof org.tangram.link.LinkHandler) {
            org.tangram.link.LinkHandler linkHandler = (org.tangram.link.LinkHandler)handler;
            this.registerInterfaceHandler(linkHandler, immutable);
            if (!this.staticLinkHandlers.containsValue(linkHandler)) {
                this.staticLinkHandlers.put(handler.getClass().getName(), linkHandler);
                this.handlers.put(handler.getClass().getName(), linkHandler);
            }
        }
        if (isAnnotated) {
            Class<?> handlerClass = handler.getClass();
            this.registerAtHandler(handlerClass, handler, immutable);
        }
    }

    @Override
    public void registerLinkHandler(Object handler) {
        this.registerLinkHandler(handler, handler.getClass().getAnnotation(LinkHandler.class) != null, true);
    }

    private <T> T createInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        LOG.info("createInstance() {} is marked @LinkHandler", (Object)clazz.getName());
        T instance = clazz.newInstance();
        LOG.info("createInstance() {} instanciated", (Object)instance.getClass().getName());
        return instance;
    }

    @Override
    public void reset() {
        this.methods = new HashMap<Pattern, Method>();
        this.methods.putAll(this.staticMethods);
        this.atHandlers = new HashMap<Pattern, Object>();
        this.atHandlers.putAll(this.staticAtHandlers);
        this.handlers = new HashMap<String, org.tangram.link.LinkHandler>();
        this.handlers.putAll(this.staticLinkHandlers);
        for (Map.Entry entry : this.classRepository.getAnnotated(LinkHandler.class).entrySet()) {
            try {
                this.registerLinkHandler(this.createInstance(entry.getValue()), true, false);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("reset()", (Throwable)e);
            }
        }
        for (Map.Entry<String, Class<Object>> entry : this.classRepository.get(org.tangram.link.LinkHandler.class).entrySet()) {
            try {
                this.registerLinkHandler(this.createInstance(entry.getValue()), false, false);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("reset()", (Throwable)e);
            }
        }
    }

    public ViewContext handleRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String url = request.getRequestURI().substring(this.linkFactoryAggregator.getPrefix(request).length());
        int idx = url.indexOf(59);
        if (idx > 0) {
            url = url.substring(0, idx);
        }
        LOG.info("handleRequest() {}", (Object)url);
        Utils.setPrimaryBrowserLanguageForJstl(request);
        for (Map.Entry<Pattern, Method> entry : this.methods.entrySet()) {
            Pattern p = entry.getKey();
            LOG.debug("handleRequest() url pattern {}", (Object)p.pattern());
            Matcher matcher = p.matcher(url);
            if (!matcher.matches()) continue;
            LOG.debug("handleRequest() match {}", (Object)matcher.groupCount());
            Object target = this.atHandlers.get(entry.getKey());
            TargetDescriptor descriptor = new TargetDescriptor(target, null, null);
            TargetDescriptor resultDescriptor = this.callAction(request, response, matcher, entry.getValue(), descriptor, target);
            return resultDescriptor != TargetDescriptor.DONE ? this.handleResultDescriptor(resultDescriptor, request, response) : null;
        }
        for (String className : this.handlers.keySet()) {
            org.tangram.link.LinkHandler linkHandler = this.handlers.get(className);
            TargetDescriptor descriptor = linkHandler.parseLink(url, response);
            if (descriptor == null) continue;
            LOG.info("handleRequest() {} hit for {}", (Object)linkHandler.getClass().getName(), (Object)url);
            LOG.debug("handleRequest() found bean {}", descriptor.bean);
            TargetDescriptor resultDescriptor = descriptor;
            if (descriptor.action != null) {
                LOG.debug("handleRequest() Calling {}@{}", (Object)descriptor.action, (Object)linkHandler.getClass().getSimpleName());
                Method method = this.linkFactoryAggregator.findMethod(linkHandler, descriptor.action);
                resultDescriptor = this.callAction(request, response, null, method, descriptor, linkHandler);
                if (resultDescriptor == null) {
                    LOG.debug("handleRequest() Calling '{}' at descriptor bean values", (Object)descriptor.action);
                    for (Object value : this.createModel(descriptor, request, response).values()) {
                        LOG.debug("handleRequest() trying to find action {} at {}", (Object)descriptor.action, value);
                        if (value == null || resultDescriptor != null) continue;
                        LOG.debug("handleRequest() trying to call action {}@{}", (Object)descriptor.action, (Object)value.getClass().getSimpleName());
                        method = this.linkFactoryAggregator.findMethod(value, descriptor.action);
                        resultDescriptor = this.callAction(request, response, null, method, descriptor, value);
                    }
                }
            }
            return this.handleResultDescriptor(resultDescriptor, request, response);
        }
        response.sendError(404);
        return null;
    }

    @Override
    public Link createLink(HttpServletRequest request, HttpServletResponse response, Object bean, String action, String view) {
        for (LinkFactory linkFactory : this.handlers.values()) {
            Link result = linkFactory.createLink(request, response, bean, action, view);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet()");
        this.linkFactoryAggregator.registerFactory(this);
        this.classRepository.addListener(this);
    }
}

