/*
 * Decompiled with CFR 0.152.
 */
package org.tangram;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.util.SystemUtils;

public final class Constants {
    private static final Logger LOG = LoggerFactory.getLogger(Constants.class);
    public static final String VERSION;
    public static final String THIS = "self";
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String MIME_TYPE_HTML_UTF8 = "text/html; charset=UTF-8";
    public static final String MIME_TYPE_XML = "application/xml";
    public static final String MIME_TYPE_CSS = "text/css";
    public static final String MIME_TYPE_GROOVY = "application/x-groovy";
    public static final String MIME_TYPE_JS = "application/javascript";
    public static final String MIME_TYPE_PLAIN = "text/plain";
    public static final String MIME_TYPE_MARKDOWN = "text/x-markdown";
    public static final String MIME_TYPE_SVG = "image/svg+xml";
    public static final String DEFAULT_DATE_FORMAT = "kk:mm:ss dd.MM.yyyy zzz";
    public static final String ID_PATTERN = "([A-Z][a-zA-Z]+:[0-9a-f]+)";
    public static final Pattern TEXT_ID_PATTERN;
    public static final String DEFAULT_VIEW = "NULL";
    public static final String PARAMETER_VIEW = "v";
    public static final String PARAMETER_PROTECTION_LOGIN = "protection.login.button";
    public static final String PARAMETER_PROTECTION_KEY = "protection.key";
    public static final String ATTRIBUTE_EMBEDDED_VIEW = "embedded.link.view";
    public static final String ATTRIBUTE_EMBEDDED_ACTION = "embedded.link.action";
    public static final String ATTRIBUTE_REQUEST = "request";
    public static final String ATTRIBUTE_RESPONSE = "response";
    public static final String ATTRIBUTE_VIEW_SETTINGS = "viewSettings";
    public static final String ATTRIBUTE_STATISTICS = "statistics";
    public static final String ATTRIBUTE_BEAN_FACTORY = "beanFactory";
    public static final String ATTRIBUTE_VIEW_UTILITIES = "viewUtilities";
    public static final String ATTRIBUTE_LINK_FACTORY_AGGREGATOR = "linkFactoryAggregator";
    public static final String ATTRIBUTE_LOGIN_RESULT = "loginResult";
    public static final String ATTRIBUTE_PROTECTION = "protection";
    public static final String ATTRIBUTE_PARAMETER_ACCESS = "parameter.access";
    public static final String ATTRIBUTE_RETURN_URL = "tangram.return.url";
    public static final String ATTRIBUTE_USERS = "tangram.users";
    public static final String PROPERTY_VERSION_BUILD = "version.build";
    public static final int RIP_CORD_COUNT = 8;
    public static final String VERSION_MAJOR = "1";
    public static final String VERSION_MINOR = "2";
    public static final Map<String, String> VERSIONS;
    private static final String PREFIX = "tangram";
    private static final String SUFFIX = "-build.properties";
    private static final int SUFFIX_LENGTH;

    private Constants() {
    }

    static {
        TEXT_ID_PATTERN = Pattern.compile("http://[a-zA-Z0-9:]*\"");
        VERSIONS = new HashMap<String, String>();
        SUFFIX_LENGTH = SUFFIX.length();
        try {
            for (String s : SystemUtils.getResourceListing(PREFIX, SUFFIX)) {
                Properties p = new Properties();
                p.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(s));
                VERSIONS.put(s.substring(8, s.length() - SUFFIX_LENGTH), p.getProperty(PROPERTY_VERSION_BUILD));
            }
        }
        catch (Exception e) {
            LOG.error("Error while reading all modules building properties", (Throwable)e);
        }
        StringBuilder versionBuilder = new StringBuilder(128);
        versionBuilder.append(VERSION_MAJOR);
        versionBuilder.append('.');
        versionBuilder.append(VERSION_MINOR);
        for (String key : VERSIONS.keySet()) {
            versionBuilder.append('.');
            versionBuilder.append(key);
            versionBuilder.append(VERSIONS.get(key));
        }
        VERSION = versionBuilder.toString();
    }
}

