/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.BeanListener;
import org.tangram.content.Content;
import org.tangram.logic.ClassRepository;
import org.tangram.logic.Shim;
import org.tangram.logic.ShimProvider;
import org.tangram.logic.ShimProviderAware;
import org.tangram.logic.ViewShim;
import org.tangram.util.SystemUtils;
import org.tangram.view.DefaultViewContextFactory;

public class DynamicViewContextFactory
extends DefaultViewContextFactory
implements BeanListener,
ShimProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicViewContextFactory.class);
    @Inject
    private ClassRepository classRepository;
    private Map<String, List<Constructor<Shim>>> definedViewShims;
    private Map<String, List<Constructor<Shim>>> definedBeanShims;
    private Map<String, List<Constructor<Shim>>> cachedViewShims;
    private Map<String, List<Constructor<Shim>>> cachedBeanShims;

    private void defineShim(Map<String, List<Constructor<Shim>>> definedShims, Class<? extends Content> beanClass, Constructor<Shim> shimClass, int constructorParameterCount) {
        if (shimClass.getParameterTypes().length != constructorParameterCount) {
            return;
        }
        List<Constructor<Shim>> shims = definedShims.get(beanClass.getName());
        LOG.info("defineShim() defining shim {}: {}", (Object)beanClass.getSimpleName(), shimClass);
        if (shims == null) {
            shims = new ArrayList<Constructor<Shim>>();
            definedShims.put(beanClass.getName(), shims);
        }
        shims.add(shimClass);
    }

    protected void defineViewShim(Class<? extends Content> beanClass, Constructor<Shim> shimClass) {
        this.defineShim(this.definedViewShims, beanClass, shimClass, 2);
    }

    protected void defineBeanShim(Class<? extends Content> beanClass, Constructor<Shim> shimClass) {
        this.defineShim(this.definedBeanShims, beanClass, shimClass, 1);
    }

    @Override
    public void reset() {
        LOG.debug("reset()");
        this.definedViewShims = new HashMap<String, List<Constructor<Shim>>>();
        this.definedBeanShims = new HashMap<String, List<Constructor<Shim>>>();
        this.cachedViewShims = new HashMap<String, List<Constructor<Shim>>>();
        this.cachedBeanShims = new HashMap<String, List<Constructor<Shim>>>();
        if (this.classRepository != null) {
            for (Class<Shim> c : this.classRepository.get(Shim.class).values()) {
                try {
                    ParameterizedType pt = (ParameterizedType)c.getGenericSuperclass();
                    Type[] actualTypes = pt.getActualTypeArguments();
                    Class beanClass = (Class)SystemUtils.convert(actualTypes[0]);
                    String className = c.getName();
                    if (ViewShim.class.isAssignableFrom(c)) {
                        LOG.info("reset() defining view shim {} for {}", (Object)className, (Object)beanClass.getName());
                        this.defineViewShim(beanClass, c.getConstructor(HttpServletRequest.class, beanClass));
                        continue;
                    }
                    if (!Shim.class.isAssignableFrom(c)) continue;
                    LOG.info("reset() defining bean shim {} for {}", (Object)className, (Object)beanClass.getName());
                    this.defineBeanShim(beanClass, c.getConstructor(beanClass));
                }
                catch (Throwable e) {
                    LOG.error("reset()", e);
                }
            }
        }
    }

    private List<Constructor<Shim>> getShimsFor(Map<String, List<Constructor<Shim>>> definedShims, Map<String, List<Constructor<Shim>>> cachedShims, Class<? extends Object> shimFor) {
        List<Constructor<Shim>> result = cachedShims.get(shimFor.getName());
        if (result == null) {
            result = new ArrayList<Constructor<Shim>>();
            cachedShims.put(shimFor.getName(), result);
            LOG.debug("getShimsFor() defining shims for {}", (Object)shimFor.getName());
            while (shimFor != null) {
                List<Constructor<Shim>> shims = definedShims.get(shimFor.getName());
                if (shims != null) {
                    result.addAll(shims);
                }
                shimFor = shimFor.getSuperclass();
            }
            if (LOG.isDebugEnabled()) {
                for (Constructor<Shim> sct : result) {
                    LOG.debug("getShimsFor() - {}", (Object)sct.getDeclaringClass().getSimpleName());
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getShims(HttpServletRequest request, Object bean) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Class<?> shimFor = bean.getClass();
            LOG.debug("getShims() getting shims for {}", (Object)shimFor.getName());
            List<Constructor<Shim>> viewShims = this.getShimsFor(this.definedViewShims, this.cachedViewShims, shimFor);
            for (Constructor<Shim> ct : viewShims) {
                if (ct == null) continue;
                LOG.debug("getShims() view shim for bean {} is {}", (Object)bean.getClass().getSimpleName(), (Object)ct.getDeclaringClass().getSimpleName());
                Shim result = ct.newInstance(request, bean);
                if (result instanceof ShimProviderAware) {
                    LOG.debug("getShims() provider aware");
                    ((ShimProviderAware)((Object)result)).setShimProvider(this);
                } else {
                    LOG.debug("getShims() not provider aware");
                }
                LOG.debug("getShims() storing shim as {}", (Object)result.getAttributeName());
                resultMap.put(result.getAttributeName(), result);
            }
            List<Constructor<Shim>> beanShims = this.getShimsFor(this.definedBeanShims, this.cachedBeanShims, shimFor);
            for (Constructor<Shim> ct : beanShims) {
                if (ct == null) continue;
                LOG.debug("getShims() shim for bean {} is {}", (Object)bean.getClass().getSimpleName(), (Object)ct.getDeclaringClass().getSimpleName());
                Shim result = ct.newInstance(bean);
                if (result instanceof ShimProviderAware) {
                    LOG.debug("getShims() provider aware");
                    ((ShimProviderAware)((Object)result)).setShimProvider(this);
                } else {
                    LOG.debug("getShims() not provider aware");
                }
                LOG.debug("getShims() storing shim as {}", (Object)result.getAttributeName());
                resultMap.put(result.getAttributeName(), result);
            }
        }
        catch (Exception e) {
            LOG.error("getShims() ", (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> createModel(Object bean, ServletRequest request, ServletResponse response) {
        Map<String, Object> model = super.createModel(bean, request, response);
        Map<String, Object> shims = this.getShims((HttpServletRequest)request, bean);
        for (Map.Entry<String, Object> e : shims.entrySet()) {
            model.put(e.getKey(), e.getValue());
        }
        return model;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet()");
        if (this.classRepository != null) {
            this.classRepository.addListener(this);
        } else {
            LOG.error("afterPropertiesSet() no class repository present.");
            this.reset();
        }
    }
}

