/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.tangram.content.Content;

public final class SystemUtils {
    private SystemUtils() {
    }

    public static Set<String> stringSetFromParameterString(String parameter) {
        HashSet<String> result = new HashSet<String>();
        if (StringUtils.isNotBlank((String)parameter)) {
            String[] parts;
            for (String part : parts = parameter.split(",")) {
                result.add(part.trim());
            }
        }
        return result;
    }

    private static Set<String> getResourceListing(URL pathUrl, String prefix, String suffix) throws URISyntaxException, IOException {
        HashSet<String> result = new HashSet<String>();
        if ("file".equals(pathUrl.getProtocol())) {
            for (String name : new File(pathUrl.toURI()).list()) {
                if (!name.endsWith(suffix)) continue;
                result.add(prefix + "/" + name);
            }
        }
        if ("jar".equals(pathUrl.getProtocol())) {
            String jarPath = pathUrl.getPath().substring(5, pathUrl.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                name = entries.nextElement().getName();
                if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                result.add(name);
            }
            jar.close();
        }
        return result;
    }

    public static Set<String> getResourceListing(String prefix, String suffix) throws URISyntaxException, IOException {
        HashSet<String> result = new HashSet<String>();
        Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources(prefix);
        while (en.hasMoreElements()) {
            URL metaInf = en.nextElement();
            result.addAll(SystemUtils.getResourceListing(metaInf, prefix, suffix));
        }
        return result;
    }

    public static String getSha256Hash(String value) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hash = md.digest(value.getBytes("UTF-8"));
        StringBuilder hexString = new StringBuilder(32);
        for (int i = 0; i < hash.length; ++i) {
            int element = 0xFF & hash[i];
            if (element < 16) {
                hexString.append('0');
            }
            hexString.append(Integer.toHexString(element));
        }
        return hexString.toString();
    }

    public static <T> T convert(Object bean) {
        return (T)bean;
    }

    public static List<Content> convertList(Object contents) {
        return (List)contents;
    }
}

