/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.net.URLDecoder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.controller.ControllerHook;
import org.tangram.link.Link;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.link.TargetDescriptor;

@Named
@Singleton
public class UniqueUrlHook
implements ControllerHook {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueUrlHook.class);
    @Inject
    private LinkFactoryAggregator linkFactory;

    @Override
    public boolean intercept(TargetDescriptor descriptor, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Link link;
        block4: {
            link = null;
            try {
                link = this.linkFactory.createLink(request, response, descriptor.bean, descriptor.action, descriptor.view);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn("intercept() expensive things happen " + (descriptor.bean == null ? "" : descriptor.bean.getClass().getName()));
            }
        }
        if (link != null) {
            String requestURI;
            String queryString = request.getQueryString();
            queryString = StringUtils.isBlank((String)queryString) ? "" : "?" + queryString;
            String decodedUrl = URLDecoder.decode(link.getUrl(), "UTF-8") + queryString;
            if (!decodedUrl.equals(requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8") + queryString)) {
                LOG.info("intercept() sending redirect for {} to {}", (Object)requestURI, (Object)decodedUrl);
                response.setHeader("Location", link.getUrl());
                response.setStatus(301);
                return true;
            }
        }
        return false;
    }
}

