/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.http.profile.HttpProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.CodeResource;
import org.tangram.content.CodeResourceCache;
import org.tangram.util.SystemUtils;

@Named(value="usernamePasswordAuthenticator")
@Singleton
public class SimpleAuthenticator
implements UsernamePasswordAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAuthenticator.class);
    @Inject
    @Named(value="usernamePasswordMapping")
    @Resource(name="usernamePasswordMapping")
    private Map<String, String> usernamePasswordMapping;
    @Inject
    private CodeResourceCache codeResourceCache;

    public void validate(UsernamePasswordCredentials upc) {
        LOG.info("validate() {} in {}", (Object)upc.getUsername(), this.usernamePasswordMapping);
        try {
            LOG.debug("validate() {}", this.codeResourceCache.getTypeCache("text/plain"));
            CodeResource code = this.codeResourceCache.getTypeCache("text/plain").get("users.properties");
            Properties p = new Properties();
            try {
                LOG.debug("validate() {}", (Object)code);
                if (code != null) {
                    p.load(code.getStream());
                }
            }
            catch (Exception e) {
                LOG.error("validate() error while reading user database", (Throwable)e);
            }
            p.putAll(this.usernamePasswordMapping);
            String hash = SystemUtils.getSha256Hash(upc.getPassword());
            Object storedHash = p.get(upc.getUsername());
            LOG.debug("validate() {} in {} ({})", new Object[]{upc.getUsername(), p, storedHash});
            if (storedHash == null || !storedHash.equals(hash)) {
                throw new RuntimeException("wrong credentials");
            }
            HttpProfile profile = new HttpProfile();
            profile.setId((Object)upc.getUsername());
            profile.addAttribute("username", (Object)upc.getUsername());
            upc.setUserProfile((UserProfile)profile);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error("validate()", (Throwable)e);
            throw new RuntimeException("internal error: " + e.getMessage(), e);
        }
    }
}

