/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.PersistentRestartCache;
import org.tangram.content.BeanFactory;
import org.tangram.content.BeanListener;
import org.tangram.content.CodeResource;
import org.tangram.content.CodeResourceCache;
import org.tangram.content.TransientCode;
import org.tangram.util.SystemUtils;

@Named(value="codeResourceCache")
@Singleton
public class GenericCodeResourceCache
implements CodeResourceCache {
    private static final String CODE_RESOURCE_CACHE_KEY = "tangram.code.resource.cache";
    private static final Logger LOG = LoggerFactory.getLogger(GenericCodeResourceCache.class);
    @Inject
    private PersistentRestartCache startupCache;
    @Inject
    private BeanFactory factory;
    private long lastResetTime;
    private final List<BeanListener> attachedListeners = new ArrayList<BeanListener>();
    private Map<String, Map<String, CodeResource>> resourceCache;
    private Map<String, CodeResource> cache;

    @Override
    public void reset() {
        ArrayList<TransientCode> resources = null;
        if (this.resourceCache == null) {
            resources = (List)SystemUtils.convert(this.startupCache.get(CODE_RESOURCE_CACHE_KEY, List.class));
            LOG.info("reset() cache: {}", (Object)resources);
        }
        if (resources == null) {
            LOG.info("reset() obtaining all code resources");
            List<CodeResource> datastoreResources = this.factory.listBeans(CodeResource.class);
            resources = new ArrayList<TransientCode>();
            for (CodeResource resource : datastoreResources) {
                resources.add(new TransientCode(resource));
            }
            this.startupCache.put(CODE_RESOURCE_CACHE_KEY, resources);
        }
        this.resourceCache = new HashMap<String, Map<String, CodeResource>>(resources.size());
        this.cache = new HashMap<String, CodeResource>(this.resourceCache.size());
        for (CodeResource codeResource : resources) {
            this.cache.put(codeResource.getId(), codeResource);
            String mimeType = codeResource.getMimeType();
            if (!StringUtils.isNotBlank((String)mimeType)) continue;
            Map<String, CodeResource> typeCache = this.resourceCache.get(mimeType);
            if (typeCache == null) {
                typeCache = new HashMap<String, CodeResource>();
                this.resourceCache.put(mimeType, typeCache);
            }
            if (!StringUtils.isNotEmpty((String)codeResource.getAnnotation())) continue;
            typeCache.put(codeResource.getAnnotation(), codeResource);
        }
        LOG.info("reset() code resources obtained");
        for (BeanListener beanListener : this.attachedListeners) {
            beanListener.reset();
        }
        LOG.info("reset() listeners notified");
        this.lastResetTime = System.currentTimeMillis();
    }

    @Override
    public long getLastUpdate() {
        return this.lastResetTime;
    }

    @Override
    public CodeResource get(String mimeType, String annotation) {
        Map<String, CodeResource> typeCache = this.resourceCache.get(mimeType);
        return typeCache == null ? null : typeCache.get(annotation);
    }

    @Override
    public CodeResource get(String id) {
        return this.cache.get(id);
    }

    @Override
    public Set<String> getTypes() {
        return this.resourceCache.keySet();
    }

    @Override
    public Collection<CodeResource> getCodes() {
        return this.cache.values();
    }

    @Override
    public Collection<String> getAnnotations(String mimeType) {
        Map<String, CodeResource> typeCache = this.resourceCache.get(mimeType);
        return typeCache != null ? typeCache.keySet() : new HashSet<String>();
    }

    @Override
    public Map<String, CodeResource> getTypeCache(String mimeType) {
        HashMap typeCache = this.resourceCache.get(mimeType);
        return typeCache != null ? typeCache : new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BeanListener listener) {
        List<BeanListener> list = this.attachedListeners;
        synchronized (list) {
            this.attachedListeners.add(listener);
        }
        listener.reset();
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.debug("afterPropertiesSet()");
        this.factory.addListener(CodeResource.class, this);
    }
}

