/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view.jsp;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.link.Link;
import org.tangram.link.LinkFactoryAggregator;

public class LinkTag
implements Tag,
Serializable {
    private static final long serialVersionUID = 7615554589005573155L;
    private static final Logger LOG = LoggerFactory.getLogger(LinkTag.class);
    private PageContext context = null;
    private Tag parent = null;
    private Object bean = null;
    private String action = null;
    private String view = null;
    private boolean href = false;
    private boolean target = false;
    private boolean handlers = false;

    public void setPageContext(PageContext p) {
        this.context = p;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag t) {
        this.parent = t;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String s) {
        this.view = s;
    }

    public boolean isHref() {
        return this.href;
    }

    public void setHref(boolean href) {
        this.href = href;
    }

    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public boolean isHandlers() {
        return this.handlers;
    }

    public void setHandlers(boolean handlers) {
        this.handlers = handlers;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public static void render(LinkFactoryAggregator builder, HttpServletRequest req, HttpServletResponse resp, Writer writer, Object bean, String action, String view, boolean isHref, boolean isTarget, boolean isHandlers) {
        try {
            Link link = builder.createLink(req, resp, bean, action, view);
            if (isHref) {
                writer.write("href=\"");
            }
            writer.write(link.getUrl());
            if (isHref) {
                writer.write("\" ");
            }
            if (isTarget && link.getTarget() != null) {
                writer.write("target=\"" + link.getTarget() + "\" ");
            }
            if (isHandlers) {
                for (Map.Entry<String, String> entry : link.getHandlers().entrySet()) {
                    writer.write(entry.getKey() + "=\"" + entry.getValue() + "\" ");
                }
            }
        }
        catch (IOException ioe) {
            LOG.error("doEndTag() could not paste link into output");
        }
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.context.getOut();
        HttpServletRequest request = (HttpServletRequest)this.context.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.context.getResponse();
        ServletContext servletContext = this.context.getServletContext();
        LinkFactoryAggregator builder = (LinkFactoryAggregator)servletContext.getAttribute("linkFactoryAggregator");
        LinkTag.render(builder, request, response, (Writer)out, this.getBean(), this.getAction(), this.getView(), this.isHref(), this.isTarget(), this.isHandlers());
        return 6;
    }

    public void release() {
        this.context = null;
        this.parent = null;
        this.bean = null;
        this.action = null;
        this.view = null;
        this.href = false;
        this.target = false;
        this.handlers = false;
    }
}

