/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.PersistentRestartCache;
import org.tangram.util.SystemUtils;

public class FileRestartCache
implements PersistentRestartCache {
    private static final String PERSISTENT_CACHE_FILENAME_DEFAULT = "tangram.persistent.cache.ser";
    private static final String PERSISTENT_CACHE_HASH_KEY = "tangram.cache.hash";
    private static final Logger LOG = LoggerFactory.getLogger(FileRestartCache.class);
    private String filename = "tangram.persistent.cache.ser";
    private String markerResourceName = "org/tangram/content";
    private Map<String, Object> cache = null;

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setMarkerResourceName(String markerResourceName) {
        this.markerResourceName = markerResourceName;
    }

    @Override
    public <T> T get(String key, Class<T> c) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    @Override
    public <T> T get(String key, Type t) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    @Override
    public <T> void put(String key, T value) {
        if (this.cache != null) {
            this.cache.put(key, value);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));){
                oos.writeObject(this.cache);
            }
            catch (IOException e) {
                LOG.error("put()", (Throwable)e);
            }
        }
    }

    @PostConstruct
    public void afterPropertiesSet() {
        String hashValue = "";
        try {
            LOG.info("afterPropertiesSet() looking up {}", (Object)this.markerResourceName);
            URL packageUrl = Thread.currentThread().getContextClassLoader().getResource(this.markerResourceName);
            if (packageUrl != null) {
                LOG.info("afterPropertiesSet() package url is {}", (Object)packageUrl);
                File markerFile = null;
                if (packageUrl.getProtocol().equals("jar")) {
                    URL jarUrl = new URL(packageUrl.getFile());
                    String uriString = jarUrl.toURI().getPath();
                    int idx = uriString.indexOf(33);
                    if (idx > 0) {
                        uriString = uriString.substring(0, idx);
                    }
                    markerFile = new File(uriString);
                }
                if (packageUrl.getProtocol().equals("file")) {
                    markerFile = new File(packageUrl.toURI());
                }
                LOG.info("afterPropertiesSet() look up returned {}", markerFile);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                hashValue = formatter.format(new Date(markerFile.lastModified()));
            } else {
                LOG.warn("afterPropertiesSet() no resource found for {}", (Object)this.markerResourceName);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.info("afterPropertiesSet() url syntax error which you are not expected to see.", (Throwable)e);
        }
        LOG.info("afterPropertiesSet({})", (Object)this.filename);
        boolean resetCache = true;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.filename));){
            this.cache = (Map)SystemUtils.convert(ois.readObject());
            Object storedHash = this.cache.get(PERSISTENT_CACHE_HASH_KEY);
            LOG.info("afterPropertiesSet() stored {} vs. generated {}", storedHash, (Object)hashValue);
            resetCache = storedHash == null || !storedHash.toString().equals(hashValue);
        }
        catch (Exception e) {
            LOG.warn("afterPropertiesSet() could not load cache '{}' starting with an empty set of values", (Object)this.filename);
        }
        if (resetCache) {
            LOG.info("afterPropertiesSet() resetting cache");
            this.cache = new HashMap<String, Object>();
            this.cache.put(PERSISTENT_CACHE_HASH_KEY, hashValue);
        }
    }
}

