/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ClassResolver.class);
    private final Set<String> packageNames;
    private final Set<String> classNames;

    private void addPathsForPackage(Set<String> urls, String packageName) {
        String packagePath = packageName.replace('.', '/');
        try {
            Enumeration<URL> urlEnumeration = Thread.currentThread().getContextClassLoader().getResources(packagePath);
            while (urlEnumeration.hasMoreElements()) {
                String url = urlEnumeration.nextElement().toString();
                int idx = url.indexOf(33);
                url = idx > 0 ? url.substring(0, idx) : url;
                url = url.startsWith("jar:") ? url.substring(4) : url;
                url = url.startsWith("vfs:/") ? "file" + url.substring(3, url.length() - packagePath.length() - 2) : url;
                url = url.startsWith("file:") ? url.substring(5) : url;
                url = !url.endsWith(".jar") ? url.substring(0, url.length() - packagePath.length()) : url;
                LOG.info("addPathsForPackage() {}", (Object)url);
                urls.add(url);
            }
        }
        catch (IOException e) {
            LOG.error("addPathsForPackage()", (Throwable)e);
        }
    }

    private void checkClassAndAdd(Set<String> classNames, String name) {
        LOG.debug("checkClassAndAdd() name={}", (Object)name);
        if (name.endsWith(".class") && name.indexOf(36) < 0) {
            name = name.replace(File.separatorChar, '/').replace('/', '.');
            String className = name.substring(0, name.length() - 6);
            boolean add = false;
            for (String packageName : this.packageNames) {
                add = add || className.startsWith(packageName);
            }
            if (add) {
                classNames.add(className);
            }
        }
    }

    private void recurseSubDir(Set<String> classNames, File dir, int basePathLength) {
        LOG.debug("recurseSubDir() scanning {}", (Object)dir.getAbsolutePath());
        for (File f : dir.isDirectory() ? dir.listFiles() : new File[]{}) {
            String fileName = f.getAbsolutePath().substring(basePathLength);
            LOG.debug("recurseSubDir() fileName={}", (Object)fileName);
            if (fileName.endsWith(".class") || fileName.endsWith(".properties")) {
                this.checkClassAndAdd(classNames, fileName);
                continue;
            }
            this.recurseSubDir(classNames, f, basePathLength);
        }
    }

    public ClassResolver(Set<String> packageNames) {
        LOG.debug("getClassNames() packageNames={}", packageNames);
        this.packageNames = packageNames;
        this.classNames = new HashSet<String>();
        HashSet<String> paths = new HashSet<String>();
        for (String packageName : packageNames) {
            this.addPathsForPackage(paths, packageName);
        }
        for (String path : paths) {
            try {
                path = URLDecoder.decode(path, "UTF-8");
                LOG.debug("getClassNames() path={}", (Object)path);
                if (path.endsWith(".jar")) {
                    JarInputStream is = new JarInputStream(new FileInputStream(path));
                    JarEntry entry = is.getNextJarEntry();
                    while (entry != null) {
                        String name = entry.getName().replace('/', '.');
                        this.checkClassAndAdd(this.classNames, name);
                        entry = is.getNextJarEntry();
                    }
                    is.close();
                    continue;
                }
                File dir = new File(path);
                int basePathLength = dir.getAbsolutePath().length() + 1;
                this.recurseSubDir(this.classNames, dir, basePathLength);
            }
            catch (IOException e) {
                LOG.error("getClassNames()", (Throwable)e);
            }
        }
    }

    public static final <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public <T> Set<Class<T>> getSubclasses(Class<T> c) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (String className : this.classNames) {
            try {
                Class<T> cls = ClassResolver.loadClass(className);
                if (!c.isAssignableFrom(cls)) continue;
                result.add(cls);
            }
            catch (ClassNotFoundException e) {
                LOG.error("getSubclasses()", (Throwable)e);
            }
        }
        return result;
    }

    public <T> Set<Class<T>> getAnnotatedSubclasses(Class<T> c, Class<? extends Annotation> annotation) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (String className : this.classNames) {
            try {
                Class<T> cls = ClassResolver.loadClass(className);
                if (cls.getAnnotation(annotation) == null || !c.isAssignableFrom(cls) || cls.isInterface()) continue;
                result.add(cls);
            }
            catch (ClassNotFoundException e) {
                LOG.error("getAnnotatedSubclasses()", (Throwable)e);
            }
        }
        return result;
    }
}

