/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.tangram.monitor.Statistics;

@Named(value="statistics")
@Singleton
public class SimpleStatistics
implements Statistics {
    private final Map<String, Long> counter = new HashMap<String, Long>();
    private final Date startTime = new Date();

    public Map<String, Long> getCounter() {
        return this.counter;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void increase(String eventIdentifier) {
        long value = this.counter.containsKey(eventIdentifier) ? this.counter.get(eventIdentifier) + 1L : 1L;
        this.counter.put(eventIdentifier, value);
    }

    @Override
    public void avg(String eventIdentifier, long value) {
        String countKey = eventIdentifier + " count";
        this.increase(countKey);
        long median = this.counter.containsKey(eventIdentifier) ? this.counter.get(eventIdentifier) : 0L;
        long count = this.counter.get(countKey);
        this.counter.put(eventIdentifier, (median * (count - 1L) + value) / count);
    }
}

