/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view.velocity;

import java.io.InputStream;
import java.util.Date;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.content.CodeResource;
import org.tangram.content.CodeResourceCache;

public class VelocityResourceLoader
extends ResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(VelocityResourceLoader.class);
    public static CodeResourceCache codeResourceCache;

    public long getLastModified(Resource resource) {
        long update;
        CodeResource code = codeResourceCache.get(resource.getName());
        long l = update = code.getModificationTime() > 99L ? code.getModificationTime() : codeResourceCache.getLastUpdate();
        if (LOG.isInfoEnabled()) {
            LOG.info("getLastModified({}) {}", (Object)resource.getName(), (Object)new Date(update));
        }
        return update;
    }

    public InputStream getResourceStream(String source) {
        InputStream result = null;
        if (!"VM_global_library.vm".equals(source)) {
            try {
                LOG.debug("getResourceStream() {}", (Object)source);
                CodeResource t = codeResourceCache.get(source);
                if (t != null) {
                    result = t.getStream();
                }
            }
            catch (Exception e) {
                LOG.error("getResourceStream() " + e.getMessage());
            }
        }
        return result;
    }

    public void init(ExtendedProperties configuration) {
        LOG.info("init() {}", (Object)configuration);
    }

    public boolean isSourceModified(Resource resource) {
        long update = this.getLastModified(resource);
        if (LOG.isInfoEnabled()) {
            LOG.info("isSourceModified({}) {} {}", new Object[]{resource.getName(), new Date(resource.getLastModified()), new Date(update)});
        }
        return update > resource.getLastModified();
    }

    public boolean resourceExists(String resourceName) {
        LOG.info("resourceExists() {}", (Object)resourceName);
        return codeResourceCache.get(resourceName) != null;
    }
}

