/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.annotate.LinkAction;
import org.tangram.annotate.LinkHandler;
import org.tangram.annotate.LinkPart;
import org.tangram.content.Content;
import org.tangram.content.blob.MimedBlob;
import org.tangram.controller.AbstractLinkHandler;
import org.tangram.link.InternalLinkFactory;
import org.tangram.link.Link;
import org.tangram.link.TargetDescriptor;
import org.tangram.view.Utils;

@Named
@Singleton
@LinkHandler
public class DefaultHandler
extends AbstractLinkHandler
implements InternalLinkFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHandler.class);
    private int maxInlinedBlobSize = 1024;

    public void setMaxInlinedBlobSize(int maxInlinedBlobSize) {
        this.maxInlinedBlobSize = maxInlinedBlobSize;
        LOG.info("setMaxInlinedBlobSize() max size is {}", (Object)this.maxInlinedBlobSize);
    }

    @LinkAction(value="/id_([A-Z][a-zA-Z]+:[0-9a-f]+)/view_([a-zA-Z0-9]+)")
    public TargetDescriptor render(@LinkPart(value=1) String id, @LinkPart(value=2) String view, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Utils.setPrimaryBrowserLanguageForJstl(request);
        LOG.debug("render() id={} view={}", (Object)id, (Object)view);
        Content content = this.beanFactory.getBean(id);
        LOG.debug("render() content={}", (Object)content);
        if (content == null) {
            response.sendError(404, "no content with id " + id + " in repository.");
            return null;
        }
        return new TargetDescriptor(content, view, null);
    }

    @LinkAction(value="/id_([A-Z][a-zA-Z]+:[0-9a-f]+)")
    public TargetDescriptor render(@LinkPart(value=1) String id, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.render(id, null, request, response);
    }

    @Override
    public Link createLink(HttpServletRequest request, HttpServletResponse r, Object bean, String action, String view) {
        Link result = null;
        if (bean instanceof Content && action == null) {
            if (view == null && bean instanceof MimedBlob) {
                MimedBlob blob = (MimedBlob)bean;
                LOG.debug("createLink() mimed blob link for {}", (Object)blob);
                StringBuilder url = new StringBuilder(this.maxInlinedBlobSize);
                byte[] bytes = blob.getBytes();
                if (bytes.length < this.maxInlinedBlobSize) {
                    url.append("data:");
                    url.append(blob.getMimeType());
                    url.append(";base64,");
                    url.append(Base64.encodeBase64String((byte[])bytes));
                } else {
                    url.append("/id_");
                    url.append(((Content)bean).getId());
                }
                result = new Link(url.toString());
            } else {
                String url = "/id_" + ((Content)bean).getId() + (view == null ? "" : "/view_" + view);
                result = new Link(url);
                result.setTarget("_tangram_view");
            }
        }
        return result;
    }
}

