/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.monitor.Statistics;
import org.tangram.view.TemplateResolver;

public abstract class AbstractTemplateResolver<T>
implements TemplateResolver<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTemplateResolver.class);
    private final boolean suppressBrackets;
    private final String packageSeparator;
    private String name = this.getClass().getSimpleName();
    private boolean activateCaching = true;
    private final Map<String, T> cache = new HashMap<String, T>();
    @Inject
    private Statistics statistics;

    protected AbstractTemplateResolver(boolean suppressBrackets, String packageSeparator) {
        this.suppressBrackets = suppressBrackets;
        this.packageSeparator = packageSeparator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActivateCaching() {
        return this.activateCaching;
    }

    public void setActivateCaching(boolean activateCaching) {
        this.activateCaching = activateCaching;
    }

    protected Map<String, T> getCache() {
        return this.cache;
    }

    protected abstract T getNotFoundDummy();

    protected String getFullViewName(String view, String packageName, String simpleName) {
        if (this.suppressBrackets & simpleName.endsWith("[]")) {
            simpleName = simpleName.replace("[]", "_array");
        }
        String viewPrefix = StringUtils.isNotBlank((String)packageName) ? packageName + this.packageSeparator : "";
        return viewPrefix + simpleName + ("NULL".equals(view) ? "" : "." + view);
    }

    protected abstract T resolveView(String var1, Locale var2) throws Exception;

    protected abstract T checkResourceExists(T var1);

    protected T checkView(String view, String packageName, String simpleName, String key, Locale locale) {
        Object result = null;
        String path = this.getFullViewName(view, packageName, simpleName);
        LOG.info("checkView({}) view={}  path={}", new Object[]{this.getName(), view, path});
        try {
            result = this.resolveView(path, locale);
            LOG.debug("checkView() resolved view {}", result);
            if (result != null) {
                result = this.checkResourceExists(result);
            }
            LOG.debug("checkView() result={}", result);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getClass().getName().indexOf("Parse") >= 0) {
                throw (RuntimeException)e.getCause();
            }
            LOG.warn("checkView()", (Throwable)e);
        }
        return result;
    }

    protected T lookupView(String viewName, Locale locale, Object content, String key) throws IOException {
        T view = null;
        HashSet<String> alreadyChecked = new HashSet<String>();
        ArrayList allInterfaces = new ArrayList();
        for (Class<?> cls = content.getClass(); view == null && cls != null; cls = cls.getSuperclass()) {
            String pack = cls.getPackage() == null ? "" : cls.getPackage().getName();
            view = this.checkView(viewName, pack, cls.getSimpleName(), key, locale);
            if (view != null) continue;
            for (Object i : ClassUtils.getAllInterfaces(cls)) {
                if (!allInterfaces.contains(i)) continue;
                allInterfaces.remove(i);
            }
            for (Object i : ClassUtils.getAllInterfaces(cls)) {
                allInterfaces.add(i);
            }
        }
        if (view == null) {
            for (Object i : allInterfaces) {
                Class c = (Class)i;
                LOG.debug("lookupView() type to check templates for {}", (Object)c.getName());
                if (alreadyChecked.contains(c.getName())) continue;
                alreadyChecked.add(c.getName());
                String interfacePackage = c.getPackage() == null ? "" : c.getPackage().getName();
                view = this.checkView(viewName, interfacePackage, c.getSimpleName(), key, locale);
                if (view == null) continue;
                break;
            }
        }
        return view;
    }

    @Override
    public T resolveTemplate(String viewName, Map<String, Object> model, Locale locale) throws IOException {
        T view;
        LOG.debug("resolveTemplate({}) {}", (Object)this.getName(), (Object)viewName);
        Object content = model.get("self");
        if (content == null) {
            return null;
        }
        Class<?> cls = content.getClass();
        String key = cls.getName() + "#" + viewName;
        if (this.activateCaching && this.cache.containsKey(key)) {
            this.statistics.increase("template lookup cached " + this.getName());
            T result = this.cache.get(key);
            if (result == this.getNotFoundDummy()) {
                result = null;
            }
            return result;
        }
        this.statistics.increase("template lookup uncached " + this.getName());
        T cacheView = view = this.lookupView(viewName, locale, content, key);
        if (view == null) {
            LOG.info("resolveTemplate({}) no template found for {}", (Object)this.getName(), (Object)content.getClass().getSimpleName());
            cacheView = this.getNotFoundDummy();
        }
        if (this.activateCaching) {
            this.cache.put(key, cacheView);
        }
        return view;
    }
}

