/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.view;

import java.io.File;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.view.AbstractTemplateResolver;
import org.tangram.view.TemplateResolver;

public abstract class AbstractInternalResourceTemplateResolver<T>
extends AbstractTemplateResolver<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInternalResourceTemplateResolver.class);
    private String prefix = "/WEB-INF/view/jsp/";
    private String suffix = ".jsp";
    private String filePathPrefix;

    public AbstractInternalResourceTemplateResolver() {
        super(true, "/");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.filePathPrefix = servletContext.getRealPath("");
    }

    protected String checkJspExists(String url) {
        LOG.info("checkJspExists({})", (Object)url);
        String resourcePrefix = "/META-INF/resources";
        URL resource = this.getClass().getResource(resourcePrefix + url);
        if (resource == null) {
            File f = new File(this.filePathPrefix + url);
            LOG.debug("checkJspExists() f={}", (Object)f.getAbsolutePath());
            if (!f.exists()) {
                url = null;
            }
        }
        return url;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (StringUtils.isBlank((String)this.filePathPrefix)) {
            LOG.error("afterPropertiesSet() path to lookup templates may not be null");
        }
    }

    @Override
    public int compareTo(TemplateResolver<T> o) {
        return 1;
    }
}

