/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBean {
    private static final Logger LOG = LoggerFactory.getLogger(JavaBean.class);
    private final Object delegate;
    private final Map<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();

    public static PropertyDescriptor[] getPropertyDescriptors(Class<? extends Object> cls) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(cls);
        return info.getPropertyDescriptors();
    }

    public JavaBean(Object delegate) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        this.delegate = delegate;
        for (PropertyDescriptor descriptor : propertyDescriptors = JavaBean.getPropertyDescriptors(delegate.getClass())) {
            this.descriptors.put(descriptor.getName(), descriptor);
        }
    }

    public Collection<String> propertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.descriptors.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public Object get(String name) {
        Object result = null;
        Method readMethod = this.descriptors.get(name).getReadMethod();
        if (readMethod != null) {
            try {
                result = readMethod.invoke(this.delegate, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOG.error("get()", (Throwable)ex);
            }
        }
        return result;
    }

    public boolean isReadable(String name) {
        return this.descriptors.containsKey(name) && this.descriptors.get(name).getReadMethod() != null;
    }

    public void set(String name, Object value) {
        Method writeMethod = this.descriptors.get(name).getWriteMethod();
        if (writeMethod != null) {
            try {
                writeMethod.invoke(this.delegate, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOG.error("set(" + name + " :" + this.descriptors.get(name).getPropertyType() + ")", (Throwable)ex);
            }
        }
    }

    public boolean isWritable(String name) {
        return this.descriptors.containsKey(name) && this.descriptors.get(name).getWriteMethod() != null;
    }

    public Class<? extends Object> getType(String name) {
        return this.descriptors.get(name).getPropertyType();
    }

    public Class<? extends Object> getCollectionType(String name) {
        ParameterizedType returnType = (ParameterizedType)this.descriptors.get(name).getReadMethod().getGenericReturnType();
        return (Class)returnType.getActualTypeArguments()[0];
    }
}

