/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.PersistentRestartCache;
import org.tangram.util.SystemUtils;

public class FileRestartCache
implements PersistentRestartCache {
    private static final String PERSISTENT_CACHE_FILENAME_DEFAULT = "tangram.persistent.cache.ser";
    private static final Logger LOG = LoggerFactory.getLogger(FileRestartCache.class);
    private String filename = "tangram.persistent.cache.ser";
    private Map<String, Object> cache = null;

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public <T> T get(String key, Class<T> c) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    @Override
    public <T> T get(String key, Type t) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    @Override
    public <T> void put(String key, T value) {
        if (this.cache != null) {
            this.cache.put(key, value);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));){
                oos.writeObject(this.cache);
            }
            catch (IOException e) {
                LOG.error("put()", (Throwable)e);
            }
        }
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOG.info("afterPropertiesSet({})", (Object)this.filename);
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.filename));){
            this.cache = (Map)SystemUtils.convert(ois.readObject());
        }
        catch (Exception e) {
            LOG.warn("afterPropertiesSet() could not load cache '{}' starting with an empty set of values", (Object)this.filename);
            this.cache = new HashMap<String, Object>();
        }
    }
}

