/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationHeaderFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ExpirationHeaderFilter.class);
    private Map<String, Long> extensionTimes = new HashMap<String, Long>();
    private final DateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private final String startTimeString;
    private final String startTimeHeader;

    public ExpirationHeaderFilter() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        long startTime = System.currentTimeMillis();
        this.startTimeString = "\"" + startTime + "-";
        this.startTimeHeader = this.formatter.format(new Date(startTime));
    }

    public void destroy() {
        this.extensionTimes = new HashMap<String, Long>();
    }

    public void addExpirationTime(String extension, long time) {
        this.extensionTimes.put(extension, time);
    }

    private Long getTimeObject(String contentType) {
        if (contentType == null) {
            return this.extensionTimes.get("DEFAULT");
        }
        Long object = this.extensionTimes.get(contentType.split(";")[0]);
        if (object == null) {
            return this.extensionTimes.get("DEFAULT");
        }
        return object;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)resp;
        response.setHeader("X-Tangram", "ExpirationFilter");
        String uri = ((HttpServletRequest)req).getRequestURI();
        int idx = uri.lastIndexOf(46);
        if (idx > 0) {
            long time;
            String extension = uri.substring(idx + 1);
            Long timeObject = this.getTimeObject(extension);
            LOG.debug("doFilter({}) extension={} timeObject={}", new Object[]{uri, extension, timeObject});
            if (timeObject != null && (time = timeObject.longValue()) > 0L) {
                long expirationValue = System.currentTimeMillis() + time * 1000L;
                LOG.debug("doFilter() expirationValue=", (Object)expirationValue);
                String expires = this.formatter.format(new Date(expirationValue));
                LOG.debug("doFilter() expires={}", (Object)expires);
                response.addHeader("Cache-Control", "max-age=" + time);
                response.addHeader("Etag", this.startTimeString + uri.hashCode() + "\"");
                response.addHeader("Expires", expires);
                response.addHeader("Last-Modified", this.startTimeHeader);
            }
        }
        chain.doFilter(req, resp);
    }

    public void init(FilterConfig config) throws ServletException {
        String expiry = config.getInitParameter("expirations");
        if (expiry != null) {
            LOG.info("init() expirations: {}", (Object)expiry);
            for (String exp : expiry.split(",")) {
                LOG.debug("init() exp: {}", (Object)exp);
                exp = exp.trim();
                String[] kvp = exp.split("=");
                String extension = kvp[0];
                String timeString = kvp[1];
                long time = Long.parseLong(timeString);
                LOG.info("init() time for {} is {}", (Object)extension, (Object)time);
                this.addExpirationTime(extension, time);
            }
        }
    }
}

