/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.link;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.annotate.LinkAction;
import org.tangram.link.InternalLinkFactory;
import org.tangram.link.Link;
import org.tangram.link.LinkFactory;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.monitor.Statistics;
import org.tangram.view.TargetDescriptor;

@Named(value="linkFactoryAggregator")
@Singleton
public class GenericLinkFactoryAggregator
implements LinkFactoryAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(GenericLinkFactoryAggregator.class);
    private static final Method NULL_METHOD = GenericLinkFactoryAggregator.class.getMethods()[0];
    @Inject
    private Statistics statistics;
    private String dispatcherPath = "/s";
    private final List<LinkFactory> factories = new ArrayList<LinkFactory>();
    private final Map<String, Method> cache = new HashMap<String, Method>();
    private String prefix = null;

    public String getDispatcherPath() {
        return this.dispatcherPath;
    }

    public void setDispatcherPath(String dispatcherPath) {
        this.dispatcherPath = dispatcherPath;
    }

    @Override
    public void registerFactory(LinkFactory factory) {
        this.factories.add(factory);
        Collections.sort(this.factories, new Comparator<LinkFactory>(){

            @Override
            public int compare(LinkFactory o1, LinkFactory o2) {
                return o2 instanceof InternalLinkFactory ? -1 : 1;
            }
        });
    }

    @Override
    public void unregisterFactory(LinkFactory factory) {
        this.factories.remove(factory);
    }

    @Override
    public String getPrefix(HttpServletRequest request) {
        if (this.prefix == null) {
            String contextPath = request.getContextPath();
            this.prefix = (contextPath.length() == 1 ? "" : contextPath) + this.dispatcherPath;
        }
        return this.prefix;
    }

    public void postProcessResult(Link result, HttpServletRequest request) {
        StringBuffer url = new StringBuffer(result.getUrl());
        int idx = url.indexOf("/");
        LOG.debug("postProcessResult() {} ({})", (Object)idx, (Object)url);
        if (idx >= 0) {
            url.insert(idx, this.getPrefix(request));
        }
        LOG.debug("postProcessResult() {} ({})", (Object)idx, (Object)url);
        result.setUrl(url.toString());
    }

    @Override
    public Link createLink(HttpServletRequest request, HttpServletResponse response, Object bean, String action, String view) {
        if (bean == null) {
            throw new RuntimeException("No bean issued for link generation in action " + action + " for view " + view);
        }
        LOG.debug("createLink() {}", this.factories);
        for (LinkFactory factory : this.factories) {
            long startTime = System.currentTimeMillis();
            Link result = factory.createLink(request, response, bean, action, view);
            LOG.debug("createLink() {} -> {} [{}]", new Object[]{factory.getClass().getName(), result, bean.getClass().getSimpleName()});
            if (result == null) continue;
            this.postProcessResult(result, request);
            this.statistics.avg("generate url time", System.currentTimeMillis() - startTime);
            return result;
        }
        throw new RuntimeException("Cannot create link for " + bean + " in action " + action + " for view " + view);
    }

    @Override
    public Method findMethod(Object target, String methodName) {
        Class<?> targetClass = target.getClass();
        String key = targetClass.getName() + "#" + methodName;
        LOG.info("findMethod() trying to find {}", (Object)key);
        Method method = this.cache.get(key);
        if (method != null) {
            return method == NULL_METHOD ? null : method;
        }
        for (Method m : targetClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            LinkAction linkAction = m.getAnnotation(LinkAction.class);
            LOG.info("findMethod() linkAction={}  method.getReturnType()={}", (Object)linkAction, m.getReturnType());
            if (!TargetDescriptor.class.equals(m.getReturnType())) {
                linkAction = null;
            }
            LOG.debug("findMethod() linkAction={}", (Object)linkAction);
            if (linkAction == null) continue;
            method = m;
        }
        this.cache.put(key, method == null ? NULL_METHOD : method);
        return method;
    }
}

