/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.tangram.content.CodeResource;
import org.tangram.content.Content;

public class TransientCode
implements CodeResource,
Serializable {
    private static final long serialVersionUID = -4573161886986101943L;
    private final String annotation;
    private final String mimeType;
    private final String id;
    private final String codeText;

    public TransientCode(String annotation, String mimeType, String id, String codeText) {
        this.annotation = annotation;
        this.mimeType = mimeType;
        this.id = id;
        this.codeText = codeText;
    }

    public TransientCode(CodeResource resource) {
        this.annotation = resource.getAnnotation();
        this.mimeType = resource.getMimeType();
        this.id = resource.getId();
        this.codeText = resource.getCodeText();
    }

    @Override
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCodeText() {
        return this.codeText;
    }

    @Override
    public long getSize() {
        return this.getCodeText().length();
    }

    @Override
    public InputStream getStream() throws Exception {
        return new ByteArrayInputStream(this.getCodeText().getBytes("UTF-8"));
    }

    @Override
    public int compareTo(Content o) {
        return o instanceof TransientCode ? (this.getMimeType() + this.getAnnotation()).compareTo(((CodeResource)o).getMimeType() + ((CodeResource)o).getAnnotation()) : -1;
    }

    public String toString() {
        return this.getAnnotation() + " (" + this.getMimeType() + ")";
    }
}

