/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.content;

import java.util.HashSet;
import java.util.Set;

public final class CodeHelper {
    private static final Set<String> EXTENSION_TO_CUT = new HashSet<String>();

    private CodeHelper() {
    }

    public static String getExtension(String mimeType) {
        if ("application/x-groovy".equals(mimeType)) {
            mimeType = "text/groovy";
        }
        if ("text/html".equals(mimeType)) {
            mimeType = "text/vtl";
        }
        if ("application/xml".equals(mimeType)) {
            mimeType = "text/vtl";
        }
        if ("application/javascript".equals(mimeType)) {
            mimeType = "text/js";
        }
        if ("text/plain".equals(mimeType)) {
            mimeType = "";
        }
        if (mimeType.startsWith("text/")) {
            mimeType = "." + mimeType.substring(5);
        }
        return mimeType;
    }

    public static String getFolder(String mimeType) {
        if ("application/x-groovy".equals(mimeType)) {
            mimeType = "text/groovy";
        }
        if ("text/html".equals(mimeType)) {
            mimeType = "text/velocity";
        }
        if ("application/xml".equals(mimeType)) {
            mimeType = "text/velocity-xml";
        }
        if ("application/javascript".equals(mimeType)) {
            mimeType = "text/js";
        }
        if (mimeType.startsWith("text/")) {
            mimeType = mimeType.substring(5);
        }
        return mimeType;
    }

    public static String getMimetype(String directoryName) {
        String result = "text/plain";
        if ("velocity".equals(directoryName)) {
            result = "text/html";
        }
        if ("velocity-xml".equals(directoryName)) {
            result = "application/xml";
        }
        if ("css".equals(directoryName)) {
            result = "text/css";
        }
        if ("js".equals(directoryName)) {
            result = "application/javascript";
        }
        if ("groovy".equals(directoryName)) {
            result = "application/x-groovy";
        }
        return result;
    }

    public static String getAnnotation(String filename) {
        int idx = filename.lastIndexOf(46);
        String extension = filename.substring(idx);
        if (EXTENSION_TO_CUT.contains(extension)) {
            filename = filename.substring(0, idx);
        }
        idx = filename.lastIndexOf(46);
        if (filename.endsWith(".vtl")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".css")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".js")) {
            filename = filename.substring(0, idx);
        }
        if (filename.endsWith(".groovy")) {
            filename = filename.substring(0, idx);
        }
        return filename;
    }

    static {
        EXTENSION_TO_CUT.add(".new");
        EXTENSION_TO_CUT.add(".old");
    }
}

