/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import groovy.lang.GroovyClassLoader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.tools.GroovyClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.PersistentRestartCache;
import org.tangram.components.CodeResourceCache;
import org.tangram.content.BeanListener;
import org.tangram.content.CodeResource;
import org.tangram.logic.ClassRepository;
import org.tangram.util.SystemUtils;

@Named(value="classRepository")
@Singleton
public class GroovyClassRepository
implements ClassRepository,
BeanListener {
    private static final String BYTECODE_CACHE_KEY = "tangram.bytecode.cache";
    private static final Logger LOG = LoggerFactory.getLogger(GroovyClassRepository.class);
    @Inject
    private CodeResourceCache codeCache;
    @Inject
    private PersistentRestartCache startupCache;
    private Map<String, Class<? extends Object>> classes = null;
    private Map<String, byte[]> byteCodes = null;
    private Map<String, String> compilationErrors = new HashMap<String, String>();
    private final List<BeanListener> attachedListeners = new ArrayList<BeanListener>();
    private GroovyClassLoader classLoader;

    protected void fillClasses() {
        this.byteCodes = (Map)SystemUtils.convert(this.startupCache.get(BYTECODE_CACHE_KEY, Map.class));
        if (this.classes != null) {
            this.byteCodes = null;
        }
        this.classLoader = new GroovyClassLoader();
        this.classes = new HashMap<String, Class<? extends Object>>();
        if (this.byteCodes == null) {
            this.compilationErrors = new HashMap<String, String>();
            this.byteCodes = new HashMap<String, byte[]>();
            HashMap<String, String> codes = new HashMap<String, String>();
            Map<String, CodeResource> typeCache = this.codeCache.getTypeCache("application/x-groovy");
            for (CodeResource resource : typeCache.values()) {
                String suffix;
                String annotation = resource.getAnnotation();
                int idx = annotation.lastIndexOf(46) + 1;
                LOG.info("fillClasses() checking for class name {} ({})", (Object)annotation, (Object)idx);
                if (idx <= 0 || Character.isLowerCase((suffix = annotation.substring(idx)).charAt(0))) continue;
                try {
                    codes.put(annotation, resource.getCodeText());
                }
                catch (Exception e) {
                    LOG.error("fillClasses()", (Throwable)e);
                }
            }
            int i = 8;
            while (i > 0 && codes.size() > this.byteCodes.size()) {
                --i;
                for (Map.Entry code : codes.entrySet()) {
                    try {
                        LOG.info("fillClasses() compiling {}", code.getKey());
                        CompilationUnit cu = new CompilationUnit(this.classLoader);
                        cu.addSource((String)code.getKey() + ".groovy", (String)code.getValue());
                        cu.compile(7);
                        List classList = (List)SystemUtils.convert(cu.getClasses());
                        if (classList.size() != 1) continue;
                        GroovyClass groovyClass = (GroovyClass)classList.get(0);
                        this.byteCodes.put(groovyClass.getName(), groovyClass.getBytes());
                        Class clazz = (Class)SystemUtils.convert(this.classLoader.defineClass(groovyClass.getName(), groovyClass.getBytes()));
                        LOG.info("fillClasses() defining {}" + clazz.getName());
                        this.classes.put(clazz.getName(), clazz);
                    }
                    catch (CompilationFailedException cfe) {
                        this.compilationErrors.put((String)code.getKey(), cfe.getMessage());
                        LOG.error("fillClasses()", (Throwable)cfe);
                    }
                    catch (Throwable t) {
                        LOG.error("fillClasses() [not marked in source code]", t);
                    }
                }
            }
            this.startupCache.put(BYTECODE_CACHE_KEY, this.byteCodes);
        } else {
            for (Map.Entry<String, byte[]> byteCode : this.byteCodes.entrySet()) {
                LOG.debug("fillClasses() defining {}", (Object)byteCode.getKey());
                Class clazz = (Class)SystemUtils.convert(this.classLoader.defineClass(byteCode.getKey(), byteCode.getValue()));
                this.classes.put(clazz.getName(), clazz);
            }
        }
        LOG.info("fillClasses() done");
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Set<String> get() {
        return this.classes.keySet();
    }

    @Override
    public <T> Map<String, Class<T>> get(Class<? extends T> cls) {
        HashMap<String, Class<T>> result = new HashMap<String, Class<T>>();
        for (Map.Entry<String, Class<? extends Object>> entry : this.classes.entrySet()) {
            if (!cls.isAssignableFrom(entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public <T> Map<String, Class<T>> getAnnotated(Class<? extends Annotation> cls) {
        HashMap<String, Class<T>> result = new HashMap<String, Class<T>>();
        for (Map.Entry<String, Class<? extends Object>> entry : this.classes.entrySet()) {
            if (entry.getValue().getAnnotation(cls) == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Class<? extends Object> get(String className) {
        return this.classes.get(className);
    }

    @Override
    public byte[] getBytes(String className) {
        return this.byteCodes.get(className);
    }

    @Override
    public void overrideClass(String className, byte[] bytes) {
        if (this.get(className) != null) {
            LOG.info("overrideClass() overriding {}", (Object)className);
            this.byteCodes.put(className, bytes);
            this.classLoader = new GroovyClassLoader();
            for (String name : this.byteCodes.keySet()) {
                LOG.debug("overrideClass() re-defining {}", (Object)name);
                Class clazz = this.classLoader.defineClass(name, this.byteCodes.get(name));
                LOG.debug("overrideClass() re-defining {}", (Object)clazz.getName());
                this.classes.put(clazz.getName(), clazz);
            }
        }
    }

    @Override
    public Map<String, String> getCompilationErrors() {
        return this.compilationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BeanListener listener) {
        List<BeanListener> list = this.attachedListeners;
        synchronized (list) {
            this.attachedListeners.add(listener);
        }
    }

    @Override
    public void reset() {
        this.fillClasses();
        for (BeanListener listener : this.attachedListeners) {
            listener.reset();
        }
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.codeCache.addListener(this);
        this.reset();
    }
}

