/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tangram.authentication.AuthenticationService;
import org.tangram.authentication.User;
import org.tangram.components.CodeResourceCache;
import org.tangram.content.BeanListener;
import org.tangram.content.CodeResource;
import org.tangram.link.Link;
import org.tangram.link.LinkFactoryAggregator;
import org.tangram.protection.AuthorizationService;
import org.tangram.util.SystemUtils;
import org.tangram.view.TargetDescriptor;
import org.tangram.view.Utils;

@Singleton
@Named(value="authorizationService")
public class GenericAuthorizationService
implements AuthorizationService,
BeanListener {
    private static final Logger LOG = LoggerFactory.getLogger(GenericAuthorizationService.class);
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private LinkFactoryAggregator linkFactoryAggregator;
    @Inject
    private CodeResourceCache codeResourceCache;
    @Inject
    @Named(value="freeUrls")
    @Resource(name="freeUrls")
    protected Set<String> freeUrls;
    @Inject
    @Named(value="allowedUsers")
    @Resource(name="allowedUsers")
    protected Set<String> allowedUsers;
    @Inject
    @Named(value="adminUsers")
    @Resource(name="adminUsers")
    protected Set<String> adminUsers;
    @Inject
    @Named(value="loginProviders")
    @Resource(name="loginProviders")
    protected Set<String> loginProviders;
    private Set<String> effectiveAdminUsers;

    @Override
    public boolean isAdminUser(HttpServletRequest request, HttpServletResponse response) {
        Set<User> users = this.authenticationService.getUsers(request, response);
        boolean result = false;
        for (User user : users) {
            LOG.info("isAdminUser() {} in {}?", (Object)user, this.adminUsers);
            result = result || this.effectiveAdminUsers.contains(user.getId());
        }
        return result;
    }

    @Override
    public TargetDescriptor getLoginTarget(HttpServletRequest request) {
        String thisURL = request.getRequestURI();
        LOG.info("getLoginTarget({}) {}", (Object)thisURL, this.loginProviders);
        request.getSession(true).setAttribute("tangram.return.url", (Object)thisURL);
        return this.authenticationService.getLoginTarget(this.loginProviders);
    }

    @Override
    public void throwIfNotAdmin(HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        if (!this.isAdminUser(request, response)) {
            throw new Exception(message);
        }
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String thisURL = request.getRequestURI().substring(Utils.getUriPrefix(request).length());
        LOG.debug("handleRequest({}) detected URI {}", (Object)this, (Object)thisURL);
        LOG.debug("handleRequest() allowed users {} ({})", this.allowedUsers, (Object)this.allowedUsers.size());
        LOG.debug("handleRequest() free urls {} ({})", this.freeUrls, (Object)this.freeUrls.size());
        if (!this.freeUrls.contains(thisURL)) {
            boolean closedSystem;
            Set<User> users = this.authenticationService.getUsers(request, response);
            boolean bl = closedSystem = !this.allowedUsers.isEmpty();
            if (this.isAdminUser(request, response)) {
                request.setAttribute("tangramAdminUser", (Object)true);
            }
            if (!users.isEmpty()) {
                boolean allowed = false;
                request.setAttribute("tangramLogoutUrl", (Object)this.authenticationService.getLogoutLink(request, response).getUrl());
                for (User user : users) {
                    allowed = allowed || this.allowedUsers.contains(user.getId());
                }
                if (closedSystem && !allowed) {
                    LOG.warn("handleRequest() user not allowed to access page: {}", users);
                    response.sendError(403, users + " not allowed to view page");
                }
            } else if (closedSystem) {
                LOG.info("handleRequest() no logged in user found while application is globally protected");
                TargetDescriptor target = this.getLoginTarget(request);
                Link loginLink = this.linkFactoryAggregator.createLink(request, response, target.getBean(), target.getAction(), target.getView());
                response.sendRedirect(loginLink.getUrl());
            }
        }
    }

    @Override
    public void reset() {
        this.effectiveAdminUsers = new HashSet<String>(this.adminUsers);
        try {
            LOG.info("reset() reading repository based additional admin users");
            CodeResource code = this.codeResourceCache.getTypeCache("text/plain").get("users.properties");
            Properties p = new Properties();
            if (code != null) {
                p.load(code.getStream());
            }
            this.effectiveAdminUsers.addAll(SystemUtils.stringSetFromParameterString(p.getProperty("adminUsers")));
            LOG.info("reset() effective admin user list is {}", this.effectiveAdminUsers);
        }
        catch (Exception e) {
            LOG.error("validate() error while reading admin user list", (Throwable)e);
        }
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.codeResourceCache.addListener(this);
        this.reset();
    }
}

