/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.components;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.tangram.annotate.LinkAction;
import org.tangram.annotate.LinkHandler;
import org.tangram.components.CodeResourceCache;
import org.tangram.content.CodeHelper;
import org.tangram.content.CodeResource;
import org.tangram.link.LinkHandlerRegistry;
import org.tangram.protection.AuthorizationService;
import org.tangram.view.TargetDescriptor;

@Named
@Singleton
@LinkHandler
public class CodeExporter {
    @Inject
    private LinkHandlerRegistry registry;
    @Inject
    private CodeResourceCache codeResourceCache;
    @Inject
    private AuthorizationService authorizationService;
    private static final Set<String> MIME_TYPES = new HashSet<String>();

    private String getFilename(CodeResource code) {
        return code.getAnnotation().replace(';', '_');
    }

    @LinkAction(value="/codes.zip")
    public TargetDescriptor codes(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.getRequestURI().endsWith(".zip")) {
            response.sendError(404);
            return null;
        }
        if (!this.authorizationService.isAdminUser(request, response)) {
            return this.authorizationService.getLoginTarget(request);
        }
        long now = System.currentTimeMillis();
        response.setContentType("application/x-zip-compressed");
        CRC32 crc = new CRC32();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
        zos.setComment("Tangram Repository Codes");
        zos.setLevel(9);
        Collection<CodeResource> codes = this.codeResourceCache.getCodes();
        for (CodeResource code : codes) {
            if (!StringUtils.isNotBlank((String)code.getAnnotation())) continue;
            String mimeType = code.getMimeType();
            String folder = CodeHelper.getFolder(mimeType);
            String extension = CodeHelper.getExtension(mimeType);
            if (!MIME_TYPES.contains(mimeType)) continue;
            byte[] bytes = code.getCodeText().getBytes("UTF-8");
            ZipEntry ze = new ZipEntry(folder + "/" + this.getFilename(code) + extension);
            ze.setTime(now);
            crc.reset();
            crc.update(bytes);
            ze.setCrc(crc.getValue());
            zos.putNextEntry(ze);
            zos.write(bytes);
            zos.closeEntry();
        }
        zos.finish();
        zos.close();
        return TargetDescriptor.DONE;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.registry.registerLinkHandler(this);
    }

    static {
        MIME_TYPES.add("application/xml");
        MIME_TYPES.add("text/html");
        MIME_TYPES.add("text/css");
        MIME_TYPES.add("application/javascript");
        MIME_TYPES.add("application/x-groovy");
    }
}

