/**
 * 
 * Copyright 2013 Martin Goellnitz
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package org.tangram;

import java.lang.reflect.Type;

/**
 * Cache to be used to speed up start up sequences.
 * 
 * Only store and ask for values which are immutable between starts
 * 
 */
public interface PersistentRestartCache {

    <T extends Object> T get(String key, Class<T> c);


    <T extends Object> T get(String key, Type t);


    <T extends Object> void put(String key, T value);

} // PersistentRestartCache
