<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
   <title>Jakarta SESSION Taglib Example</title>
</head>
<body bgcolor="#FFFFFF">

<center>
<h1>
Jakarta SESSION Taglib Example</h1></center>
<br>
<%@ taglib uri="http://jakarta.apache.org/taglibs/session-1.0" prefix="sess" %>
<p>
<pre>


<sess:session id="ss"/>
Session Information:  

       CreationTime: <jsp:getProperty name="ss" property="creationTime"/>
          SessionId: <jsp:getProperty name="ss" property="sessionId"/>
   LastAccessedTime: <jsp:getProperty name="ss" property="lastAccessedTime"/>
MaxInactiveInterval: <jsp:getProperty name="ss" property="maxInactiveInterval"/>

Set an attribute named "myatt"
<sess:setAttribute name="myatt">AAbb</sess:setAttribute>
See if myatt attribute exists
<sess:existsAttribute name="myatt">
   myatt=<sess:attribute name="myatt"/>
</sess:existsAttribute>
<sess:existsAttribute name="myatt" value="false">
   Attribute myatt does not exist.
</sess:existsAttribute>
Set an attribute named "myatt2" to the session max inactive interval
<sess:setAttribute name="myatt2"><jsp:getProperty name="ss" property="maxInactiveInterval"/></sess:setAttribute>
See if myatt equals "aabb"
<sess:equalsAttribute name="myatt" match="aabb">
  myatt=<sess:attribute name="myatt"/>
</sess:equalsAttribute>
<sess:equalsAttribute name="myatt" match="aabb" value="false">
  Attribute myatt does not equal "aabb".
</sess:equalsAttribute>
See if myatt equals "aabb", ignoring case
<sess:equalsAttribute name="myatt" match="aabb" ignoreCase="true">
  myatt=<sess:attribute name="myatt"/>
</sess:equalsAttribute>
<sess:equalsAttribute name="myatt" match="aabb" value="false" ignoreCase="true">
  Attribute myatt does not equal "aabb", ignoring case.
</sess:equalsAttribute>
Now loop through all the attributes
<sess:attributes id="att">
   <jsp:getProperty name="att" property="name"/> = <jsp:getProperty name="att" property="value"/>
</sess:attributes>
Now remove the attribute myatt
<sess:removeAttribute name="myatt"/>
See if myatt attribute exists
<sess:existsAttribute name="myatt">
   myatt=<sess:attribute name="myatt"/>
</sess:existsAttribute>
<sess:existsAttribute name="myatt" value="false">
   Attribute myatt does not exist.
</sess:existsAttribute>
</pre>
<br><br>
<p>
Is Session New?
<sess:isNew>Session is new.</sess:isNew>
<sess:isNew value="false">Session is not new.</sess:isNew>
<br><br>
Set max inactive interval to 900 seconds for session:
<sess:maxInactiveInterval>900</sess:maxInactiveInterval>
<br><br>
Check to make sure max inactive interval got set>
<br><br>
New max inactive interval = <jsp:getProperty name="ss" property="maxInactiveInterval"/> seconds
<br><br>
Now set max inactive interval back to the original value:
<br><br>
<sess:maxInactiveInterval><sess:attribute name="myatt2"/></sess:maxInactiveInterval>
<br><br>
Check to make sure max inactive interval got set back to original value:
<br><br>
Max inactive interval = <jsp:getProperty name="ss" property="maxInactiveInterval"/> seconds
</body>
</html>
