/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.TagDirImplicitTagLibrary;
import com.sun.tlddoc.TagLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WARTagDirImplicitTagLibrary
extends TagLibrary {
    private File war;
    private String dir;

    public WARTagDirImplicitTagLibrary(File war, String dir) {
        this.war = war;
        this.dir = dir;
    }

    public String getPathDescription() {
        return this.war.getAbsolutePath() + "!" + this.dir;
    }

    public InputStream getResource(String path) throws IOException {
        JarFile warFile;
        JarEntry warEntry;
        InputStream result = null;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((warEntry = (warFile = new JarFile(this.war)).getJarEntry(path)) != null) {
            result = warFile.getInputStream(warEntry);
        }
        return result;
    }

    public Document getTLDDocument(DocumentBuilder documentBuilder) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, GeneratorException {
        Document result = documentBuilder.newDocument();
        String path = this.dir;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Element taglibElement = TagDirImplicitTagLibrary.createRootTaglibNode(result, "/" + path);
        JarFile warFile = new JarFile(this.war);
        Enumeration<JarEntry> entries = warFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry warEntry = entries.nextElement();
            String entryName = warEntry.getName();
            if (warEntry.isDirectory() || !entryName.startsWith(path)) continue;
            String relativeName = entryName.replace(File.separatorChar, '/');
            if ((relativeName = relativeName.substring(path.length())).indexOf(47) != -1 || !relativeName.toLowerCase().endsWith(".tag") && !relativeName.toLowerCase().endsWith(".tagx")) continue;
            String tagName = relativeName.substring(0, relativeName.lastIndexOf(46));
            String tagPath = "/" + entryName;
            Element tagFileElement = result.createElement("tag-file");
            Element nameElement = result.createElement("name");
            nameElement.appendChild(result.createTextNode(tagName));
            tagFileElement.appendChild(nameElement);
            Element pathElement = result.createElement("path");
            pathElement.appendChild(result.createTextNode(tagPath));
            tagFileElement.appendChild(pathElement);
            taglibElement.appendChild(tagFileElement);
        }
        warFile.close();
        return result;
    }
}

