/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.core.util;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u00020\n\"\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0004J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltachiyomi/core/util/ImageUtil;", "", "()V", "gifMagic", "", "jpgMagic", "pngMagic", "webpMagic", "charByteArrayOf", "bytes", "", "", "findType", "Ltachiyomi/core/util/ImageUtil$ImageType;", "compareWith", "", "magic", "ImageType", "common"})
public final class ImageUtil {
    private static final byte[] jpgMagic;
    private static final byte[] pngMagic;
    private static final byte[] gifMagic;
    private static final byte[] webpMagic;
    public static final ImageUtil INSTANCE;

    @Nullable
    public final ImageType findType(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.compareWith(bytes, jpgMagic) ? ImageType.JPG : (this.compareWith(bytes, pngMagic) ? ImageType.PNG : (this.compareWith(bytes, gifMagic) ? ImageType.GIF : (this.compareWith(bytes, webpMagic) ? ImageType.WEBP : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean compareWith(byte[] $this$compareWith, byte[] magic) {
        int n = 0;
        int n2 = magic.length;
        while (n < n2) {
            void i;
            if ($this$compareWith[i] != magic[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] charByteArrayOf(int ... bytes) {
        int n = bytes.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            void pos;
            byte by;
            int n3 = n2;
            int n4 = n2++;
            byte[] byArray2 = byArray;
            boolean bl = false;
            byArray2[n4] = by = (byte)bytes[pos];
        }
        return byArray;
    }

    private ImageUtil() {
    }

    static {
        ImageUtil imageUtil;
        INSTANCE = imageUtil = new ImageUtil();
        jpgMagic = imageUtil.charByteArrayOf(255, 216, 255);
        pngMagic = imageUtil.charByteArrayOf(137, 80, 78, 71);
        String string = "GIF8";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        gifMagic = byArray;
        string = "RIFF";
        charset = Charsets.UTF_8;
        bl = false;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        webpMagic = byArray2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Ltachiyomi/core/util/ImageUtil$ImageType;", "", "mime", "", "extension", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "getMime", "JPG", "PNG", "GIF", "WEBP", "common"})
    public static final class ImageType
    extends Enum<ImageType> {
        public static final /* enum */ ImageType JPG;
        public static final /* enum */ ImageType PNG;
        public static final /* enum */ ImageType GIF;
        public static final /* enum */ ImageType WEBP;
        private static final /* synthetic */ ImageType[] $VALUES;
        @NotNull
        private final String mime;
        @NotNull
        private final String extension;

        static {
            ImageType[] imageTypeArray = new ImageType[4];
            ImageType[] imageTypeArray2 = imageTypeArray;
            imageTypeArray[0] = JPG = new ImageType("image/jpeg", "jpg");
            imageTypeArray[1] = PNG = new ImageType("image/png", "png");
            imageTypeArray[2] = GIF = new ImageType("image/gif", "gif");
            imageTypeArray[3] = WEBP = new ImageType("image/webp", "webp");
            $VALUES = imageTypeArray;
        }

        @NotNull
        public final String getMime() {
            return this.mime;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        private ImageType(String mime, String extension) {
            this.mime = mime;
            this.extension = extension;
        }

        public static ImageType[] values() {
            return (ImageType[])$VALUES.clone();
        }

        public static ImageType valueOf(String string) {
            return Enum.valueOf(ImageType.class, string);
        }
    }
}

