/*
 * Decompiled with CFR 0.152.
 */
package tachiyomi.core.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J+\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J7\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001c\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J+\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J7\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\u0004H\u0002J\b\u0010\"\u001a\u00020\u0004H\u0002J\b\u0010#\u001a\u00020\u0004H\u0002J\b\u0010$\u001a\u00020\u0004H\u0002J\u0014\u0010%\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J+\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J7\u0010%\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010&\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J+\u0010&\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J7\u0010&\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H)0\u0013H\u0002J1\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)0(0\u0016\"\u0004\b\u0000\u0010)*\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H)0\u00130\u0016H\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ltachiyomi/core/log/Log;", "", "()V", "MINIMUM_LEVEL_COVERS_DEBUG", "", "MINIMUM_LEVEL_COVERS_ERROR", "MINIMUM_LEVEL_COVERS_INFO", "MINIMUM_LEVEL_COVERS_TRACE", "MINIMUM_LEVEL_COVERS_WARN", "STACKTRACE_DEPTH", "", "formatter", "Lorg/tinylog/format/AdvancedMessageFormatter;", "provider", "Lorg/tinylog/provider/LoggingProvider;", "kotlin.jvm.PlatformType", "debug", "", "message", "Lkotlin/Function0;", "", "arguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "error", "info", "isCoveredByMinimumLevel", "level", "Lorg/tinylog/Level;", "isDebugEnabled", "isErrorEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled", "verbose", "warn", "asSupplier", "Lorg/tinylog/Supplier;", "T", "asSuppliers", "([Lkotlin/jvm/functions/Function0;)[Lorg/tinylog/Supplier;", "common"})
public final class Log {
    private static final int STACKTRACE_DEPTH = 2;
    private static final AdvancedMessageFormatter formatter;
    private static final LoggingProvider provider;
    private static final boolean MINIMUM_LEVEL_COVERS_TRACE;
    private static final boolean MINIMUM_LEVEL_COVERS_DEBUG;
    private static final boolean MINIMUM_LEVEL_COVERS_INFO;
    private static final boolean MINIMUM_LEVEL_COVERS_WARN;
    private static final boolean MINIMUM_LEVEL_COVERS_ERROR;
    public static final Log INSTANCE;

    public final void verbose(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, this.asSupplier(message), new Object[0]);
        }
    }

    public final void verbose(@NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void verbose(@NotNull Throwable exception, @Nullable String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public static /* synthetic */ void verbose$default(Log log, Throwable throwable, String string, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        log.verbose(throwable, string, objectArray);
    }

    public final void debug(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, this.asSupplier(message), new Object[0]);
        }
    }

    public final void debug(@NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void debug(@NotNull Throwable exception, @Nullable String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public static /* synthetic */ void debug$default(Log log, Throwable throwable, String string, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        log.debug(throwable, string, objectArray);
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, this.asSupplier(message), new Object[0]);
        }
    }

    public final void info(@NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void info(@NotNull Throwable exception, @Nullable String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public static /* synthetic */ void info$default(Log log, Throwable throwable, String string, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        log.info(throwable, string, objectArray);
    }

    public final void warn(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, this.asSupplier(message), new Object[0]);
        }
    }

    public final void warn(@NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void warn(@NotNull Throwable exception, @Nullable String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public static /* synthetic */ void warn$default(Log log, Throwable throwable, String string, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        log.warn(throwable, string, objectArray);
    }

    public final void error(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, this.asSupplier(message), new Object[0]);
        }
    }

    public final void error(@NotNull String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public final void error(@NotNull Throwable exception, @Nullable String message, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, (MessageFormatter)formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
        }
    }

    public static /* synthetic */ void error$default(Log log, Throwable throwable, String string, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        log.error(throwable, string, objectArray);
    }

    private final boolean isCoveredByMinimumLevel(Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }

    private final boolean isTraceEnabled() {
        return MINIMUM_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }

    private final boolean isDebugEnabled() {
        return MINIMUM_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG);
    }

    private final boolean isInfoEnabled() {
        return MINIMUM_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO);
    }

    private final boolean isWarnEnabled() {
        return MINIMUM_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN);
    }

    private final boolean isErrorEnabled() {
        return MINIMUM_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    private final <T> Supplier<T> asSupplier(Function0<? extends T> $this$asSupplier) {
        return new Supplier<T>($this$asSupplier){
            final /* synthetic */ Function0 $this_asSupplier;

            public final T get() {
                return (T)this.$this_asSupplier.invoke();
            }
            {
                this.$this_asSupplier = function0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Supplier<T>[] asSuppliers(Function0<? extends T>[] $this$asSuppliers) {
        void $this$mapTo$iv$iv;
        Function0<? extends T>[] $this$map$iv = $this$asSuppliers;
        boolean $i$f$map = false;
        Function0<? extends T>[] function0Array = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Supplier<T> supplier = INSTANCE.asSupplier((Function0<? extends T>)it);
            collection.add(supplier);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Supplier[] supplierArray = thisCollection$iv.toArray(new Supplier[0]);
        if (supplierArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return supplierArray;
    }

    private Log() {
    }

    static {
        Log log;
        INSTANCE = log = new Log();
        formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
        provider = ProviderRegistry.getLoggingProvider();
        MINIMUM_LEVEL_COVERS_TRACE = log.isCoveredByMinimumLevel(Level.TRACE);
        MINIMUM_LEVEL_COVERS_DEBUG = log.isCoveredByMinimumLevel(Level.DEBUG);
        MINIMUM_LEVEL_COVERS_INFO = log.isCoveredByMinimumLevel(Level.INFO);
        MINIMUM_LEVEL_COVERS_WARN = log.isCoveredByMinimumLevel(Level.WARN);
        MINIMUM_LEVEL_COVERS_ERROR = log.isCoveredByMinimumLevel(Level.ERROR);
    }
}

